<?php
session_start();
include('../intro/config.php'); // Pastikan fail ini mengandungi sambungan ke pangkalan data

// Gambar profil lalai
$default_picture = '../profile/kucing.jpg';

// Semak sama ada nama pengguna wujud dalam sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : null;

if (!$username) {
    header("Location: LoginPelajar.php"); // Halakan ke halaman login jika tidak log masuk
    exit();
}

// Dapatkan maklumat profil semasa pengguna
$sql = "SELECT profile, username FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    $profile_picture = $user['profile'] ? $user['profile'] : $default_picture;
} else {
    $profile_picture = $default_picture;
}

// Dapatkan semua fail gambar dalam folder "../profile"
$profile_folder = '../profile';
$allowed_extensions = ['jpg', 'png', 'jpeg', 'gif']; // Jenis fail yang dibenarkan
$profile_images = array_filter(scandir($profile_folder), function ($file) use ($profile_folder, $allowed_extensions) {
    $file_extension = pathinfo($file, PATHINFO_EXTENSION);
    return in_array(strtolower($file_extension), $allowed_extensions) && is_file("$profile_folder/$file");
});

// Urus kemas kini profil pengguna
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $response = ['success' => true, 'message' => 'Profil berjaya dikemas kini!'];
    
    // Kemas kini gambar profil
    if (isset($_POST['profile_picture'])) {
        $new_profile_picture = $_POST['profile_picture'];
        $update_sql = "UPDATE pelajar SET profile = ? WHERE username = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param('ss', $new_profile_picture, $username);

        if ($update_stmt->execute()) {
            $_SESSION['profile_picture'] = $new_profile_picture;
        }
    }

    // Kemas kini nama pengguna
    if (isset($_POST['new_username']) && !empty($_POST['new_username'])) {
        $new_username = $_POST['new_username'];
        $update_username_sql = "UPDATE pelajar SET username = ? WHERE username = ?";
        $update_username_stmt = $conn->prepare($update_username_sql);
        $update_username_stmt->bind_param('ss', $new_username, $username);

        if ($update_username_stmt->execute()) {
            $_SESSION['username'] = $new_username;
            $username = $new_username; // Kemas kini nama pengguna semasa
        }
    }

    // Kembalikan JSON untuk JavaScript dan keluar
    echo json_encode($response);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kemas Kini Profil</title>
    <style>
        body {
            font-family: 'Comic Sans MS', sans-serif;
            background-color: #f0f8ff;
            text-align: center;
            color: #333;
        }

        .header {
            background-color: #32cd32;
            padding: 10px;
            color: white;
        }

        .header h1 {
            margin: 0;
        }

        .container {
            margin: 20px auto;
            padding: 20px;
        }

        .profile-option {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            justify-content: center;
            margin-bottom: 20px;
        }

        .profile-option img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid transparent;
            cursor: pointer;
        }

        .profile-option input[type="radio"]:checked + img {
            border-color: #32cd32;
        }

        input[type="text"] {
            padding: 8px;
            width: 300px;
            margin-top: 10px;
            border: 2px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }

        button {
            padding: 10px 20px;
            background-color: #32cd32;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #2e8b57;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Kemas Kini Profil</h1>
    </div>

    <div class="container">
        <p>Hai, <?php echo htmlspecialchars($username); ?>! Tukar nama pengguna atau avatar anda:</p>

        <form method="post" id="update-profile-form">
            <!-- Pilih gambar profil -->
            <div class="profile-option">
                <?php foreach ($profile_images as $image): ?>
                    <label>
                        <input type="radio" name="profile_picture" value="<?php echo htmlspecialchars("$profile_folder/$image"); ?>" 
                            <?php if ($profile_picture == "$profile_folder/$image") echo 'checked'; ?>>
                        <img src="<?php echo htmlspecialchars("$profile_folder/$image"); ?>" alt="<?php echo htmlspecialchars($image); ?>">
                    </label>
                <?php endforeach; ?>
            </div>

            <!-- Tukar nama pengguna -->
            <div>
                <input type="text" name="new_username" value="<?php echo htmlspecialchars($username); ?>" placeholder="Nama Pengguna Baru" required>
            </div>
            <br>
            <!-- Hantar borang -->
            <button type="submit">Kemas Kini Profil</button>
        </form>
    </div>

    <script>
        const form = document.getElementById('update-profile-form');
        form.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(this);
            fetch('', {
                method: 'POST',
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Profil berjaya dikemas kini!');
                    window.location.href = 'indexTahun6.php'; // Pengalihan ke halaman sasaran
                } else {
                    alert('Ralat! Sila cuba lagi.');
                }
            });
        });
    </script>
</body>
</html>
