<?php
session_start();

// Masukkan fail konfigurasi untuk sambungan database
include('../intro/config.php');

// Semak jika pengguna log masuk
if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];

    // Padam akaun pengguna
    $sql = "DELETE FROM pelajar WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $username);

    if ($stmt->execute()) {
        unset($_SESSION['username']); // Log keluar
        $stmt->close();
        $conn->close();
        header('Location: ../intro/LoginPelajar.php'); // Halakan pengguna ke halaman yang diinginkan
        exit();
    } else {
        $stmt->close();
        $conn->close();
        header('Location: ../intro/LoginPelajar.php'); // Halakan pengguna walaupun gagal
        exit();
    }
} else {
    header('Location: ../intro/LoginPelajar.php'); // Halakan pengguna jika tidak log masuk
    exit();
}
?>
