<?php
// Start the session
session_start();

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the entered birth year from the hidden input
    $entered_birth_year = isset($_POST['birth_year']) ? (int)$_POST['birth_year'] : 0;

    // Validate input length and logical range
    $current_year = date("Y");
    if ($entered_birth_year >= 1900 && $entered_birth_year <= $current_year) {
        // Calculate the user's age
        $age = $current_year - $entered_birth_year;

        // Check if the user is 18 or older
        if ($age >= 18) {
            $_SESSION['age_verified'] = true;
            header("Location: settingMurid5.php");
            exit();
        } else {
            $error_message = "Access Denied: You must be 18 or older to enter this page.";
        }
    } else {
        $error_message = "Invalid birth year. Please enter a valid 4-digit year.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enter Birth Year</title>
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            position: relative;
        }

        .home-button {
            position: absolute;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            font-size: 14px;
            background-color: #3498db;
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .home-button:hover {
            background-color: #2980b9;
        }

        .container {
            text-align: center;
            padding: 30px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .container h1 {
            color: #333;
            margin-bottom: 20px;
        }

        .pin-display {
            margin-bottom: 15px;
            font-size: 24px;
            letter-spacing: 5px;
            padding: 10px;
            width: 100%;
            text-align: center;
            border: 1px solid #ccc;
            border-radius: 5px;
            background-color: #f4f4f4;
        }

        .pin-pad {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }

        .pin-pad button {
            padding: 15px;
            font-size: 18px;
            cursor: pointer;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 5px;
        }

        .pin-pad button:hover {
            background-color: #2980b9;
        }

        .submit-button {
            margin-top: 15px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            color: #fff;
            background-color: #2ecc71;
            border: none;
            border-radius: 5px;
        }

        .submit-button:hover {
            background-color: #27ae60;
        }

        .submit-button:disabled {
            background-color: #bdc3c7;
            cursor: not-allowed;
        }

        .error-message {
            color: #e74c3c;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <!-- Home Button -->
    <a href="   indexTahun5.php" class="home-button">Home</a>

    <div class="container">
        <h1>Enter Your Birth Year</h1>
        <h3>*hanya 18 keatas sahaja boleh masuk*</h3>
        <form method="POST" id="pin-form">
            <input type="hidden" name="birth_year" id="pin-input">
            <div class="pin-display" id="pin-display">----</div>
            <div class="pin-pad">
                <button type="button" onclick="appendPin('1')">1</button>
                <button type="button" onclick="appendPin('2')">2</button>
                <button type="button" onclick="appendPin('3')">3</button>
                <button type="button" onclick="appendPin('4')">4</button>
                <button type="button" onclick="appendPin('5')">5</button>
                <button type="button" onclick="appendPin('6')">6</button>
                <button type="button" onclick="appendPin('7')">7</button>
                <button type="button" onclick="appendPin('8')">8</button>
                <button type="button" onclick="appendPin('9')">9</button>
                <button type="button" onclick="clearPin()">C</button>
                <button type="button" onclick="appendPin('0')">0</button>
                <button type="submit" class="submit-button" disabled>✔</button>
            </div>
        </form>
        <?php if (isset($error_message)) : ?>
            <div class="error-message"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>
    </div>

    <script>
        let pin = "";

        function appendPin(num) {
            if (pin.length < 4) {
                pin += num;
                updateDisplay();
            }
        }

        function clearPin() {
            pin = "";
            updateDisplay();
        }

        function updateDisplay() {
            const pinDisplay = document.getElementById("pin-display");
            pinDisplay.textContent = pin.padEnd(4, "-");
            document.getElementById("pin-input").value = pin;

            // Enable the submit button only if the input is 4 digits
            const submitButton = document.querySelector(".submit-button");
            submitButton.disabled = pin.length !== 4;
        }

        // Initialize by disabling the submit button
        document.addEventListener("DOMContentLoaded", () => {
            updateDisplay();
        });
    </script>
</body>
</html>
