<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: LoginPelajar.php");
    exit();
}

$username = $_SESSION['username'];
$profile_picture = isset($_SESSION['profile_picture']) ? $_SESSION['profile_picture'] : '../profile/kucing.jpg';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Index Tahun 5</title>
    <!-- Link to External CSS -->
    <link rel="stylesheet" href="style5.css">
</head>
<body>

<!-- Background Music -->  
<audio id="background-music" autoplay loop>
    <source src="../song/backgroundSound.mp3" type="audio/mpeg">
    Your browser does not support the audio element.
</audio>

<div class="header">
    <div class="profile-username">
        <a href="../murid5/profilMurid5.php">
            <div class="profile-button">
                <img src="<?php echo htmlspecialchars($profile_picture); ?>" alt="Profile Image" style="width: 70px; height: 70px; border-radius: 50%;">
            </div>
        </a>
        <div class="username-display">
            <?php echo htmlspecialchars($username); ?>
        </div>
    </div>
    <div class="header-title">PintarKid's Game
    </div>
    <div class="settings-button" onclick="window.location.href='password5.php'">⚙️</div>
</div>


<div class="content">

    <!-- Bahasa Melayu Section -->
    <h1>BAHASA MELAYU</h1>
    <div class="scroll-wrapper">
        <div class="button-row">
            <div class="button-container">
                <button class="action-button bm-bab1-button" onclick="window.location.href='../games5/rumah/index.php';"></button>
                <br><span class="button-label">Jom Kenali Rumah Kita!</span>
            </div>
            <div class="button-container">
                <button class="action-button bm-bab2-button" onclick="window.location.href='../games5/taman permainan/index.php';"></button>
                <br><span class="button-label">Seronoknya Bermain di Taman!</span>
            </div>
            <div class="button-container">
                <button class="action-button bm-bab3-button" onclick="window.location.href='../games5/baju/index.php';"></button>
                <br><span class="button-label">Baju Cantik Saya!</span>
            </div>
            <div class="button-container">  
                <button class="action-button bm-bab4-button" onclick="window.location.href='../games5/makanan sihat/index.php';"></button>
                <br><span class="button-label">Makanan & Minuman Sihat!</span>
            </div>
        </div>
    </div>
    <br><br>

    <!-- Bahasa Inggeris Section -->
    <h1>BAHASA INGGERIS</h1>
    <div class="button-row">
        <div class="button-container">
            <button class="action-button myself-button" onclick="window.location.href='../games5/I Am Awesome/index.php';"></button>
            <br><span class="button-label">I Am Awesome!</span>
        </div>
        <div class="button-container">
            <button class="action-button my-family-button" onclick="window.location.href='../games5/MyLovingFamily/familygame.php';"></button>
            <br><span class="button-label">My Loving Family!</span>
        </div>
        <div class="button-container">
            <button class="action-button my-house-button" onclick="window.location.href='../games5/house/index.php';"></button>
            <br><span class="button-label">My Happy Home!</span>
        </div>
        <div class="button-container">
            <button class="action-button my-kindergarten-button" onclick="window.location.href='../games5/kindergarten/index.php';"></button>
            <br><span class="button-label">Fun at Kindergarten!</span>
        </div>
    </div>
    <br><br>

    <!-- Matematik Section -->
    <h1>MATEMATIK AWAL</h1>
    <div class="button-row">    
        <div class="button-container">
            <button class="action-button mari-kenal-nombor-button" onclick="window.location.href='../games5/MariKenalNombor/index.php';"></button>
            <br><span class="button-label">Mari Kenal Nombor</span>
        </div>
        <div class="button-container">
            <button class="action-button penambahan-penolakan-button" onclick="window.location.href='../games5/PenambahanPenolakan/index.php';"></button>
            <br><span class="button-label">Penambahan dan Penolakan</span>
        </div>
        <div class="button-container">
            <button class="action-button mari-mengenal-bentuk-button" onclick="window.location.href='../games5/MariMengenalBentuk/index.php';"></button>
            <br><span class="button-label">Mari Mengenal Bentuk</span>
        </div>
        <div class="button-container">
            <button class="action-button hebat-ukur-ukur-button" onclick="window.location.href='../games5/UkurUkur/index.php';"></button>
            <br><span class="button-label">Hebat,nya Ukur-Ukur!</span>
        </div>
    </div>
    <br><br>

    <!-- Sains Awal Section -->
    <h1>SAINS AWAL</h1>
    <div class="button-row">
        <div class="button-container">
            <button class="action-button sains-bab1" onclick="window.location.href='../games5/BendaHidupdanBukanHidup/index.php';"></button>
            <br><span class="button-label">Benda Hidup atau Bukan Hidup?</span>
        </div>
        <div class="button-container">
            <button class="action-button sains-bab2" onclick="window.location.href='../games5/CiriCiriHaiwan/ciricirihaiwan.php';"></button>
            <br><span class="button-label">Kenali Ciri-ciri Haiwan</span>
        </div>
        <div class="button-container">
            <button class="action-button sains-bab3" onclick="window.location.href='../games5/buah/index.php';"></button>
            <br><span class="button-label">Sayur dan Buah-Buahan</span>
        </div>
        <div class="button-container">
            <button class="action-button sains-bab4" onclick="window.location.href='../games5/KenaliHaiwanKecil/kenaliHaiwan.php';"></button>
            <br><span class="button-label">Kenali Haiwan Kecil</span>
        </div>
    </div>
    <br><br>

    <!-- Pendidikan Islam Section -->
    <h1>PENDIDIKAN ISLAM</h1>
    <div class="button-row">
        <div class="button-container">
            <button class="action-button pendidikan-islam-akidah" onclick="window.location.href='../games5/Akidah/index.php';"></button>
            <br><span class="button-label">Akidah: Kepercayaan Yang Sahih</span>
        </div>
        <div class="button-container">
            <button class="action-button pendidikan-islam-ibadah" onclick="window.location.href='../games5/Ibadah/index.php';"></button>
            <br><span class="button-label">Ibadah: Seronoknya Beribadah!</span>
        </div>
        <div class="button-container">
            <button class="action-button pendidikan-islam-sirah" onclick="window.location.href='../games5/Sirah/index.php';"></button>
            <br><span class="button-label">Sirah: Kisah Nabi-Nabi yang Hebat!</span>
        </div>
        <div class="button-container">
            <button class="action-button pendidikan-islam-akhlak" onclick="window.location.href='../games5/Akhlak/index.php';"></button>
            <br><span class="button-label">Akhlak: Perangai Baik, Hidup Bahagia!</span>
        </div>
    </div>
    <br><br>
</div>

</body>
</html>
