<?php
    // Sertakan fail config.php untuk sambungan ke pangkalan data
    require '../intro/config.php';

    // Jika borang dihantar, kemas kini tahap di pangkalan data
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        foreach ($_POST['save'] as $id => $value) {
            $tahap = $_POST['tahap'][$id];
            $sql_update = "UPDATE kindergarten SET tahap = '$tahap' WHERE id = $id";
            $conn->query($sql_update);
        }
    }

    // Jika borang delete dihantar, padamkan rekod
    if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];
        $sql_delete = "DELETE FROM kindergarten WHERE id = $delete_id";
        if ($conn->query($sql_delete)) {
            // Reorganize IDs after deletion
            $sql_reorder = "
                SET @count = 0;
                UPDATE kindergarten SET id = (@count := @count + 1);
                ALTER TABLE kindergarten AUTO_INCREMENT = 1;
            ";
            $conn->multi_query($sql_reorder);
        }
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }

    // Query untuk dapatkan data dari table kindergarten
    $sql = "SELECT id, username, score, date, TIME_FORMAT(masa_mula, '%h:%i %p') AS masa_mula FROM kindergarten";
    $result = $conn->query($sql);

    // Semak jika query berjaya dijalankan
    if (!$result) {
        die("Ralat dalam query: " . $conn->error);
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fun at Kindergaten </title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }
        h2 {
            text-align: center;
            margin: 20px;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px auto;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            text-align: center;
            padding: 15px;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        td {
            background-color: #fff;
            color: #555;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }
        .no-record {
            text-align: center;
            font-size: 18px;
            color: #888;
            padding: 20px 0;
        }
        .save-button, .delete-button, .print-button {
            padding: 8px 15px;
            border: none;
            cursor: pointer;
            display: inline-block;
            margin: 5px;
            text-align: center;
            font-size: 14px;
        }
        .save-button {
            background-color: #4CAF50;
            color: white;
        }
        .save-button:hover {
            background-color: #45a049;
        }
        .delete-button {
            background-color: red;
            color: white;
        }
        .delete-button:hover {
            background-color: #e60000;
        }
        .print-button {
            background-color: gray;
            color: white;
            margin-right: 10px;
            position: absolute;
            top: 100px;
            right: 50px;
        }
        .print-button:hover {
            background-color: #808080;
        }
        .search-container {
            text-align: center;
            margin: 20px 0;
        }
        .search-bar {
            padding: 10px;
            width: 80%;
            max-width: 400px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        nav {
            background-color: #333;
            overflow: hidden;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 10px;
        }
        nav a {
            color: white;
            text-align: center;
            padding: 14px 30px;
            text-decoration: none;
            font-size: 17px;
        }
        nav a:hover {
            background-color: #ddd;
            color: black;
        }
        nav a.active {
            background-color: #4CAF50;
            color: white;
        }
        .current-date-time {
            color: white;
            font-size: 16px;
        }
    </style>
</head>
<body>
    <nav>
        <a href="../guru/keputusanPelajar5.php" class="active">Kembali</a>
        <div class="current-date-time" id="currentDateTime"></div>
    </nav>

    <br>

    <div class="container">
        <button class="print-button" onclick="printPage()">Print Semua Rekod</button>
        <h2>Senarai Keputusan Kuiz Fun at Kindergaten </h2><br>
        <div class="search-container">
            <input type="text" id="searchInput" class="search-bar" placeholder="Cari rekod...">
        </div>
        
        <form method="post">
            <table id="resultTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Username</th>
                        <th>Score</th>
                        <th>Date</th>
                        <th>Masa Mula</th>
                        <th>Tindakan</th>
                    </tr>
                </thead>
                <tbody>
<?php
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row["id"] . "</td>";
        echo "<td>" . $row["username"] . "</td>";
        echo "<td>" . $row["score"] . "/100</td>";
        echo "<td>" . $row["date"] . "</td>";
        echo "<td>" . $row["masa_mula"] . "</td>";
        echo "<td>
                <a href='?delete_id=" . $row['id'] . "' class='delete-button'>Padamkan Rekod</a>
              </td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='6' class='no-record'>Tiada rekod dijumpai</td></tr>";
}
?>
                </tbody>
            </table>
        </form>
    </div>

    <script>
    function updateDateTime() {
        const now = new Date();
        const formattedDateTime = now.toLocaleString();
        document.getElementById('currentDateTime').textContent = formattedDateTime;
    }
    setInterval(updateDateTime, 1000);
    updateDateTime();

    const searchInput = document.getElementById('searchInput');
    const table = document.getElementById('resultTable');

    searchInput.addEventListener('keyup', function () {
        const filter = searchInput.value.toLowerCase();
        const rows = table.getElementsByTagName('tr');

        for (let i = 1; i < rows.length; i++) {
            const cells = rows[i].getElementsByTagName('td');
            let match = false;

            for (let j = 0; j < cells.length - 1; j++) {
                if (cells[j].textContent.toLowerCase().includes(filter)) {
                    match = true;
                    break;
                }
            }
            rows[i].style.display = match ? '' : 'none';
        }
    });

    function printPage() {
        const printWindow = window.open('', '', 'height=600,width=800');
        const pageContent = `
        <html>
        <head>
            <title>Print Semua Rekod</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f4f4f9;
                    margin: 0;
                    padding: 0;
                }
                h2 {
                    text-align: center;
                    margin: 20px;
                    color: #333;
                }
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin: 20px auto;
                    box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
                }
                table, th, td {
                    border: 1px solid #ddd;
                }
                th, td {
                    text-align: center;
                    padding: 15px;
                }
                th {
                    background-color: #4CAF50;
                    color: white;
                }
                td {
                    background-color: #fff;
                    color: #555;
                }
                tr:nth-child(even) {
                    background-color: #f9f9f9;
                }
                tr:hover {
                    background-color: #f1f1f1;
                }
                .container {
                    width: 90%;
                    max-width: 1200px;
                    margin: 0 auto;
                }
                .no-record {
                    text-align: center;
                    font-size: 18px;
                    color: #888;
                    padding: 20px 0;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h2>Senarai Keputusan Kuiz Kenali Rumah Kita</h2>
                <form method="post">
                    <table>
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Score</th>
                                <th>Date</th>
                                <th>Masa Mula</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${document.querySelector('#resultTable tbody').innerHTML}
                        </tbody>
                    </table>
                </form>
            </div>
        </body>
        </html>
        `;
    
        printWindow.document.write(pageContent);
        printWindow.document.close();
        printWindow.print();
    }
    </script>
</body>
</html>
