    <?php
    // Include the database configuration file
    include '../intro/config.php';

    // Set the number of records per page
    $records_per_page = 10; // Adjust this number as needed

    // Get the current page number from the URL (default is 1)
    $page = isset($_GET['page']) ? $_GET['page'] : 1;
    $start_from = ($page - 1) * $records_per_page; // Start from this record

    // Handle Delete Pelajar
    if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];
        $sql = "DELETE FROM pelajar WHERE id=$delete_id";
        $conn->query($sql);
        header("Location: dashboardGuru.php"); // Redirect to refresh the page
        exit();
    }

    // Fetch data from pelajar table with LIMIT for pagination
    $sql = "SELECT id, username, name, tahun, password FROM pelajar LIMIT $start_from, $records_per_page";
    $result = $conn->query($sql);

    // Get total number of records for pagination
    $sql_total = "SELECT COUNT(*) AS total FROM pelajar";
    $result_total = $conn->query($sql_total);
    $row_total = $result_total->fetch_assoc();
    $total_records = $row_total['total'];
    $total_pages = ceil($total_records / $records_per_page); // Calculate total number of pages
    ?>

    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Display Pelajar</title>
        <style>

          /* General Styles */
          body {
    font-family: 'Helvetica Neue', Arial, sans-serif;
    background: linear-gradient(rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), 
                url('img/bg.jpg') no-repeat center center fixed;
    background-size: cover; /* Ensures the background image covers the entire screen */
    margin: 0;
    padding: 80px 20px 20px; /* Adds spacing for the navbar */
    color: #333;
    
    }


h2 {
    color: #333;
    text-align: center;
    margin-bottom: 20px;
    font-size: 1.8em;
    font-weight: 500;
}

/* Navigation Bar Styles */
.navbar {
    background-color: #94DEA5; /* Green background */
    padding: 10px 0;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    z-index: 1000; /* Ensure it stays on top of other content */
    box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
}

.navbar .container {
    display: flex;
    justify-content: flex-end; /* Align buttons to the right */
    align-items: center;
}

.navbar-logo {
    position: absolute;
    left: 20px;
    top: 50%;
    transform: translateY(-50%);
}

.logo {
    width: 50px; /* Adjust size as needed */
    height: auto;
}

.navbar-button {
    font-size: 1.1em;
    font-weight: 600;
    color: #ffffff;
    text-decoration: none;
    padding: 10px 20px;
    border-radius: 8px;
    background-color: #4CAF50;
    transition: background-color 0.3s, transform 0.2s;
    margin: 0 10px;
}

.navbar-button:hover {
    background-color: #45a049;
    transform: translateY(-2px);
}

.navbar-button:active {
    background-color: #3e8e41;
    transform: translateY(0);
}

/* Dropdown Styles */
.dropdown {
    position: relative;
    display: inline-block;
}

.dropdown:hover .dropdown-content {
    display: block;
}

.dropdown-content {
    display: none;
    position: absolute;
    background-color: #4CAF50;
    min-width: 160px;
    z-index: 1;
    box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
    border-radius: 5px;
}

.dropdown-content a {
    color: white;
    padding: 12px 16px;
    text-decoration: none;
    display: block;
    font-size: 1em;
}

.dropdown-content a:hover {
    background-color: #45a049;
}

/* Responsive Navigation Menu for Mobile Devices */
@media (max-width: 768px) {
    .navbar .container {
        flex-direction: column; /* Stack buttons vertically */
        align-items: flex-start;
    }

    .navbar-logo {
        position: relative;
        left: 0;
        top: 0;
        transform: none;
        margin-bottom: 10px; /* Space between logo and buttons */
    }

    .navbar-button {
        width: 100%; /* Make buttons full width */
        padding: 12px 20px;
        text-align: center;
        margin: 5px 0; /* Adjust margin for better spacing */
    }

    .dropdown-content {
        position: static; /* Display below the dropdown button */
        width: 100%;
        box-shadow: none;
    }

    .dropdown-content a {
        padding: 12px 20px;
        text-align: center;
    }

    h2 {
        font-size: 1.5em; /* Smaller font size for heading on mobile */
    }
}

/* Table Styling */
table {
    width: 90%;
    max-width: 1200px;
    margin: 0 auto;
    border-collapse: collapse;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
    background-color: #ffffff;
}

th, td {
    padding: 15px;
    text-align: left;
    border-bottom: 1px solid #e8e8e8;
    font-size: 0.9em;
    color: #555;
}

th {
    background-color: #B6F49D;
    color: #333;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-size: 0.85em;
}

tr:nth-child(even) {
    background-color: #f9fafc;
}

tr:hover {
    background-color: #e6f7e6;
}

/* Button Styles */
td .action-button {
    display: inline-block;
    padding: 8px 15px;
    border-radius: 5px;
    font-size: 0.85em;
    font-weight: 600;
    text-decoration: none;
    color: #ffffff;
    background-color: #4CAF50;
    transition: background-color 0.3s, transform 0.2s;
    margin-right: 10px;
}

td .action-button:hover {
    background-color: #45a049;
    transform: translateY(-2px);
}

td .action-button:active {
    background-color: #3e8e41;
    transform: translateY(0);
}

/* Delete Button Styles */
a.delete-button {
    background-color: #f44336 !important; /* Merah */
    color: #ffffff !important;
}

a.delete-button:hover {
    background-color: #d32f2f !important; /* Merah lebih gelap */
}

a.delete-button:active {
    background-color: #b71c1c !important; /* Merah lebih gelap apabila ditekan */
}

/* Button Container */
.button-container {
    text-align: center;
    margin-top: 30px;
}

.button-container a {
    text-decoration: none;
    color: #ffffff;
    background-color: #4CAF50;
    padding: 12px 24px;
    border-radius: 8px;
    margin: 5px;
    font-size: 1em;
    font-weight: 500;
    display: inline-block;
    transition: background-color 0.3s ease, transform 0.2s ease;
}

.button-container a:hover {
    background-color: #45a049;
    transform: translateY(-2px);
}

.button-container a:active {
    background-color: #3e8e41;
    transform: translateY(0);
}

/* Pagination */
.pagination {
    text-align: center;
    margin-top: 20px;
}

.pagination a {
    color: #4CAF50;
    padding: 8px 16px;
    margin: 0 4px;
    text-decoration: none;
    border: 1px solid #ddd;
    border-radius: 5px;
}

.pagination a:hover {
    background-color: #ddd;
}

.pagination a.active {
    background-color: #4CAF50;
    color: white;
}

/* Info Box */
.info-box {
    background-color: #fff8e1;
    border-left: 5px solid #ff9800;
    padding: 15px;
    margin-bottom: 30px;
    font-size: 1em;
    color: #333;
    font-weight: 500;
    text-align: center;
}

.info-box ul {
    margin: 0;
    padding: 0 20px;
}

.info-box ul li {
    list-style-type: disc;
    margin-bottom: 10px;
}

.info-box code {
    font-size: 1.1em;
    color: #f57c00;
}

/* Responsive Design */
@media (max-width: 768px) {
    table, th, td {
        font-size: 0.85em;
    }

    .button-container a {
        padding: 10px 20px;
        font-size: 0.9em;
    }

    .navbar-button {
        font-size: 1em;
        padding: 8px 15px;
    }

    .navbar-logo img {
        width: 40px; /* Adjust logo size for mobile */
    }
}

        </style>
    </head>
    <body>

    <div class="navbar">
        <div class="container">

            <!-- Logo -->
            <a href="#" class="navbar-logo">
                <img src="../background/logo1.jpg" alt="Logo" class="logo">
            </a>

            <!-- Navigation Buttons -->
            <a href="../intro/LoginPelajar.php" class="navbar-button">Login Page</a>
            
            <!-- Keputusan Pelajar Dropdown -->
            <div class="dropdown">
                <a href="#" class="navbar-button">Keputusan Pelajar</a>
                <div class="dropdown-content">
                    <a href="keputusanPelajar5.php">5 tahun</a>
                    <a href="keputusanPelajar6.php">6 tahun</a>
                </div>
            </div>
        </div>
    </div>

    <h2>Data Pelajar 5 tahun dan 6 tahun</h2>

    <!-- Information Box Below the Title -->
    <div class="info-box">
        <strong>Note:</strong> Untuk admin Tadika Anggerik Biru, sekiranya anda ingin menambah pelajar baru: 
        <ul><br>
            <li><strong>Pelajar 5 tahun:</strong> Sila letakkan <code>'a'</code> di hadapan password.</li>
            <li><strong>Pelajar 6 tahun:</strong> Sila letakkan <code>'b'</code> di hadapan password.</li>
        </ul>
    </div>

    <!-- Pelajar Data Table -->
    <table>
    <tr>
        <th>ID</th>
        <th>Username</th>
        <th>Name</th>
        <th>Age</th>
        <th>Password</th>
        <th>Actions</th>
    </tr>
    <?php
    // Initialize a counter
    $counter = 1;

    // Display records
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            // Use the counter instead of the database ID
            echo "<td>" . $counter++ . "</td>";
            echo "<td>" . $row["username"] . "</td>";
            echo "<td>" . $row["name"] . "</td>";
            echo "<td>" . $row["tahun"] . "<span>&nbsp;</span>tahun</td>";
            echo "<td>" . $row["password"] . "</td>";
            echo "<td>";
            echo "<a href='editPelajar.php?id=" . $row["id"] . "' class='action-button'>Edit</a>";
            echo "<a href='dashboardGuru.php?delete_id=" . $row["id"] . "' class='action-button delete-button' onclick='return confirm(\"Are you sure you want to delete this record?\")'>Delete</a>";
            echo "</td>";
            echo "</tr>";
        }
    } else {
        echo "<tr><td colspan='5' class='text-center'>No data available</td></tr>";
    }
    ?>
</table>

    <!-- Pagination -->
    <div class="pagination">
        <?php
        for ($i = 1; $i <= $total_pages; $i++) {
            echo "<a href='dashboardGuru.php?page=" . $i . "' class='" . ($page == $i ? 'active' : '') . "'>" . $i . "</a>";
        }
        ?>
    </div>

    <!-- Back Button -->
    <div class="button-container">
        <a href="addPelajar.php">Tambah Pelajar</a>
    </div>

    </body>
    </html>

    <?php
    // Close the database connection
    $conn->close();
    ?>
