<?php
// Sambungkan ke pangkalan data
include('../intro/config.php');

// Inisialisasi $error sebagai string kosong untuk mengelakkan amaran
$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Semak dalam pangkalan data
    $sql = "SELECT * FROM guru WHERE username = ? AND password = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ss', $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Log masuk berjaya, arahkan ke halaman lain (contohnya dashboard guru)
        header("Location: dashboardGuru.php");
        exit();
    } else {
        $error = "Nama pengguna atau kata laluan salah!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log Masuk Guru</title>
    <style>
        /* Gaya untuk halaman log masuk dengan background */
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-image: url('../background/background.jpg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .login-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 350px;
        }

        .login-container img {
            width: 150px;
            height: auto;
            margin-bottom: 20px;
        }

        .login-container h2 {
            font-family: 'Arial', sans-serif;
            color: #333;
            margin-bottom: 20px;
        }

        .login-container input[type="text"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            font-size: 16px;
            border: 2px solid #3498db;
            border-radius: 5px;
            box-sizing: border-box;
        }

        .login-container button {
            font-family: 'Arial', sans-serif;
            font-size: 18px;
            padding: 10px 20px;
            color: #fff;
            background-color: #3498db;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-transform: uppercase;
            width: 100%;
            margin-bottom: 10px; /* Jarak bawah untuk butang */
        }

        .login-container button:hover {
            background-color: #2980b9;
        }

        .login-container .back-button {
            background-color: #95a5a6;
            margin-top: 10px;
            padding: 10px 20px;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-transform: uppercase;
            width: 100%;
        }

        .login-container .back-button:hover {
            background-color: #7f8c8d;
        }

        .login-container .forgot-password {
            display: block;
            margin-top: 10px;
            font-size: 14px;
            color: #3498db;
            text-decoration: none;
        }

        .login-container .forgot-password:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="login-container">
    <!-- Logo -->
    <img src="../background/logo1.jpg" alt="Logo">
    <!-- Tajuk -->
    <h2>Sila Log Masuk Sebagai Guru</h2>
    <!-- Borang log masuk guru -->
    <form action="LoginGuru.php" method="POST">
        <input type="text" name="username" placeholder="Masukkan Nama Pengguna" required>
        <input type="password" name="password" placeholder="Masukkan Kata Laluan" required>
        <a href="forgotPassword.php" class="forgot-password">Lupa kata laluan?</a><br>
        <button type="submit">Log Masuk</button>
    </form>
    <!-- Butang Kembali -->
    <button class="back-button" onclick="window.history.back();">Kembali</button>
</div>

<?php if ($error != ""): ?>
<script>
    alert("<?php echo $error; ?>");
</script>
<?php endif; ?>

</body>
</html>
