<?php
session_start(); // Mulakan sesi

// Import sambungan ke pangkalan data
require '../../intro/config.php';

// Semak jika pengguna log masuk
if (!isset($_SESSION['username'])) {
    echo json_encode(['success' => false, 'message' => 'Pengguna tidak log masuk.']);
    exit;
}

$username = $_SESSION['username']; // Ambil username dari sesi

// Dapatkan skor daripada JSON POST
$data = json_decode(file_get_contents("php://input"), true);
$score = isset($data['score']) ? (int)$data['score'] : 0;

// Masukkan skor ke dalam jadual `sirah6`
$sql = "INSERT INTO sirah6 (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("si", $username, $score);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Ralat semasa menyimpan skor: ' . $stmt->error]);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Ralat penyediaan pernyataan: ' . $conn->error]);
}

// Tutup sambungan
$conn->close();
?>
