<?php
session_start();

// Retrieve the score and start time
$score = $_SESSION['score'] ?? 0;
$totalQuestions = 10; // Total number of questions

// Database connection
require_once '../../intro/config.php'; // Ensure this path is correct

// Get the username from the session (assuming the username is stored in session after login)
$username = $_SESSION['username'] ?? '';

// Calculate the number of correct answers (1 correct = 1 star)
$correctAnswers = $score / 10; // Each correct answer gives 10 points
$stars = str_repeat("⭐", $correctAnswers); // Create a string of stars

// Save the score to the database
if ($username) {
    // Prepare the SQL query
    $sql = "INSERT INTO publicplaces (username, score) VALUES ('$username', '$score')";

    // Execute the query
    if ($conn->query($sql) === TRUE) {
        // Successfully inserted the data
    } else {
        // If error occurs while inserting
        echo "Error: " . $sql . "<br>" . $conn->error;
    }
}

// Reset the session for the next game
$_SESSION['score'] = 0;
unset($_SESSION['start_time']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Over</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="result-container">
        <h1>Congratulations!</h1>
        <p>You have successfully completed the game!</p>
        
        <!-- Display total score -->
        <p>Your final score: <?= $score ?> / <?= $totalQuestions * 10 ?></p> <!-- Total score -->

        <!-- Display stars based on correct answers -->
        <p> <?= $stars ?></p>
        
        <a href="../../murid6/indexTahun6.php?level=0" class="btn">Kembali Ke Halaman Utama</a>
    </div>
</body>
</html>
