<?php
session_start();

$levels = [
    ["image" => "img/park.png", "word" => "park", "missing" => "a"],
    ["image" => "img/school.png", "word" => "school", "missing" => "o"],
    ["image" => "img/hospital.png", "word" => "hospital", "missing" => "o"],
    ["image" => "img/mosque.png", "word" => "mosque", "missing" => "e"],
    ["image" => "img/market.png", "word" => "market", "missing" => "a"],
    ["image" => "img/library.png", "word" => "library", "missing" => "i"],
    ["image" => "img/station.png", "word" => "station", "missing" => "a"],
    ["image" => "img/cinema.png", "word" => "cinema", "missing" => "i"],
    ["image" => "img/field.png", "word" => "field", "missing" => "e"],
    ["image" => "img/beach.png", "word" => "beach", "missing" => "a"],
];

$level = isset($_GET['level']) ? (int)$_GET['level'] : 0;
if ($level >= count($levels)) {
    header("Location: result.php");
    exit;
}

$current = $levels[$level];

// Start the score and start time if not set
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

if (!isset($_SESSION['start_time'])) {
    $_SESSION['start_time'] = time(); // Set start time when game begins
}

$message = ""; // Message for feedback

// Handle choice submission
if (isset($_GET['choice'])) {
    if ($_GET['choice'] == $current['missing']) {
        $_SESSION['score'] += 10; // Increment score for correct answer
        $message = "Correct!";
    } else {
        $message = "Wrong, try the next one!";
    }
    $level++; // Move to the next level for both correct and incorrect answers
    header("Location: ?level=$level&message=" . urlencode($message)); // Redirect with message
    exit;
}

// Retrieve message from the URL if set
if (isset($_GET['message'])) {
    $message = $_GET['message'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Public Places Game</title>
    <link rel="stylesheet" href="style.css">
    
</head>
<body>
    <div class="game-container">
        <!-- Score Display -->
        <div class="score">
            Score: <?= $_SESSION['score'] ?>/100
        </div>

        <!-- Settings Button -->
        <button class="settings-button" onclick="window.location.href='settings.php'">Tetapan</button>

        <div class="game-content">
            <h2> FILL IN THE BLANK </h2>

            <img src="<?= $current['image'] ?>" alt="Image of <?= $current['word'] ?>">
            <div class="word-container">
                <?php
                $word = str_split($current['word']);
                foreach ($word as $letter) {
                    if ($letter === $current['missing']) {
                        echo "<span class='missing-letter'>_</span>";
                    } else {
                        echo "<span class='letter'>$letter</span>";
                    }
                }
                ?>
            </div>
            
            <!-- Show message for feedback -->
            <?php if ($message): ?>
                <p class="feedback-message"><?= htmlspecialchars($message) ?></p>
            <?php endif; ?>
            
            <div class="choices">
                <?php
                $choices = ['a', 'e', 'i', 'o', 'u'];
                shuffle($choices);
                foreach ($choices as $choice) {
                    echo "<button class='choice' onclick=\"window.location.href='?level=$level&choice=$choice'\">$choice</button>";
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>
