<?php
session_start();
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0; // Ensure the score is initialized
}

// Database connection
include_once "../../intro/config.php"; // Ensure this file contains your DB connection setup

$score = $_SESSION['score'];
$total_score = 100; // Total score out of 100 (10 points per question)
$total_questions = 10; // Total number of questions
$stars = $score / 10; // 1 star per correct answer

// Fetch the username from the logged-in session
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'Unknown';

// Save the score to the database
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $conn->prepare("INSERT INTO occupations (username, score) VALUES (?, ?)");
    $stmt->bind_param("si", $username, $score);
    $stmt->execute();
    $stmt->close();

    // Clear quiz-related session variables but keep the user logged in
    unset($_SESSION['score']);
    unset($_SESSION['question_index']);

    header("Location: ../../murid6/indexTahun6.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Result</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Your Score</h1>
        <p>You scored <?= $score ?> out of <?= $total_score ?>!</p>
        <div class="stars">
            <?php for ($i = 0; $i < $stars; $i++): ?>
                <span class="star">&#9733;</span>
            <?php endfor; ?>
            <?php for ($i = $stars; $i < $total_questions; $i++): ?>
                <span class="star" style="color: #ccc;">&#9734;</span>
            <?php endfor; ?>
        </div>
        <form method="POST">
            <button type="submit" class="start-btn">Kembali Ke Halaman Utama</button>
        </form>
    </div>
</body>
</html>
