<?php
session_start();

// Reset the score and question index if this is the start of a new game
if (!isset($_SESSION['started']) || $_SESSION['started'] === false) {
    $_SESSION['score'] = 0;
    $_SESSION['question_index'] = 0;
    $_SESSION['started'] = true; // Mark the game as started
}

// Questions and answers
$questions = [
    ["img" => "images/doctor.jpg", "options" => ["Doctor", "Teacher", "Pilot", "Engineer"], "answer" => "Doctor"],
    ["img" => "images/teacher.jpg", "options" => ["Engineer", "Teacher", "Chef", "Police Officer"], "answer" => "Teacher"],
    ["img" => "images/chef.jpg", "options" => ["Chef", "Lawyer", "Nurse", "Firefighter"], "answer" => "Chef"],
    ["img" => "images/polis.jpg", "options" => ["Doctor", "Police Officer", "Artist", "Pilot"], "answer" => "Police Officer"],
    ["img" => "images/firefighter.jpg", "options" => ["Farmer", "Firefighter", "Pilot", "Chef"], "answer" => "Firefighter"],
    ["img" => "images/pilot.jpg", "options" => ["Teacher", "Chef", "Pilot", "Engineer"], "answer" => "Pilot"],
    ["img" => "images/engineer.jpg", "options" => ["Engineer", "Lawyer", "Doctor", "Farmer"], "answer" => "Engineer"],
    ["img" => "images/farmer.jpg", "options" => ["Farmer", "Firefighter", "Nurse", "Artist"], "answer" => "Farmer"],
    ["img" => "images/nurse.jpg", "options" => ["Chef", "Nurse", "Pilot", "Doctor"], "answer" => "Nurse"],
    ["img" => "images/artist.jpg", "options" => ["Artist", "Engineer", "Police Officer", "Chef"], "answer" => "Artist"]
];

// Handle answer submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Make sure the selected answer is set
    if (isset($_POST['answer'])) {
        $selected = $_POST['answer'];
        $index = $_SESSION['question_index'];
        if ($selected === $questions[$index]['answer']) {
            $_SESSION['score'] += 10; // Increment score by 10 for each correct answer
        }
        $_SESSION['question_index']++;

        // Redirect to the result page if all questions are answered
        if ($_SESSION['question_index'] >= count($questions)) {
            $_SESSION['started'] = false; // Mark the game as ended
            header('Location: result.php');
            exit();
        } else {
            header('Location: game.php');
            exit();
        }
    }
}

// Ensure valid question index is set
$index = $_SESSION['question_index'];
if ($index < 0 || $index >= count($questions)) {
    $_SESSION['question_index'] = 0; // Reset if invalid index
    $index = 0;
}

$current_question = $questions[$index];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game</title>
    <link rel="stylesheet" href="style.css">
    <script>
        function submitAnswer(option) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = 'game.php';

            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'answer';
            input.value = option;

            form.appendChild(input);
            document.body.appendChild(form);
            form.submit();
        }
    </script>
</head>
<body>
    <div class="container">
        <h2>Question <?= $index + 1 ?> of <?= count($questions) ?></h2>
        <p>Score: <?= $_SESSION['score'] ?>/100</p>
        <img src="<?= $current_question['img'] ?>" alt="Occupation Image" class="question-image">
        <div>
            <?php foreach ($current_question['options'] as $option): ?>
                <div onclick="submitAnswer('<?= $option ?>')" style="cursor: pointer;">
                    <input type="radio" id="<?= $option ?>" name="answer" value="<?= $option ?>" style="display: none;">
                    <label for="<?= $option ?>"><?= $option ?></label>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
