document.addEventListener("DOMContentLoaded", () => {
    const scoreElement = document.getElementById("score");
    const levelElement = document.getElementById("level");
    const threejsContainer = document.getElementById("threejs-container");

    let score = 0;
    let level = 1;
    const totalLevels = 5; // Kurangkan jumlah level untuk kesesuaian usia

    // Tetapkan jawapan yang betul dengan nama mudah
    const correctAnswers = {
        1: 'block', // Blok (kubus)
        2: 'ball',  // Bola (sfera)
        3: 'can',   // Tin (silinder)
        4: 'cone',  // Kon (piramid)
        5: 'block', // Blok
    };

    // Fungsi untuk memeriksa jawapan
    function checkAnswer(selectedAnswer) {
        if (correctAnswers[level] === selectedAnswer) {
            score += 20; // Tambah skor untuk setiap jawapan betul
            alert("Betul! Syabas! 😊");
        } else {
            alert("Salah! Jawapan yang betul ialah " + correctAnswers[level] + ".");
        }

        // Kemas kini skor dan tahap
        scoreElement.textContent = score;

        if (level < totalLevels) {
            level++;
            levelElement.textContent = level;
            loadNextShape(level);
        } else {
            alert("Tahniah! Anda telah tamat permainan dengan skor: " + score + "!");
            redirectToScorePage();
        }
    }

    // Fungsi untuk memuatkan bentuk 3D berdasarkan level
    function loadNextShape(level) {
        // Kosongkan kontena Three.js
        while (threejsContainer.firstChild) {
            threejsContainer.removeChild(threejsContainer.firstChild);
        }

        // Tetapkan bentuk baru berdasarkan tahap
        let shape;
        const scene = new THREE.Scene();
        const camera = new THREE.PerspectiveCamera(75, threejsContainer.offsetWidth / threejsContainer.offsetHeight, 0.1, 1000);
        const renderer = new THREE.WebGLRenderer();

        renderer.setSize(threejsContainer.offsetWidth, threejsContainer.offsetHeight);
        threejsContainer.appendChild(renderer.domElement);

        const geometry = getGeometryByLevel(level);
        const material = new THREE.MeshBasicMaterial({ color: getRandomColor() }); // Warna rawak
        shape = new THREE.Mesh(geometry, material);

        scene.add(shape);
        camera.position.z = 5;

        // Animasi bentuk
        function animate() {
            requestAnimationFrame(animate);
            shape.rotation.x += 0.02;
            shape.rotation.y += 0.02;
            renderer.render(scene, camera);
        }
        animate();
    }

    // Fungsi untuk mendapatkan geometri berdasarkan tahap
    function getGeometryByLevel(level) {
        switch (correctAnswers[level]) {
            case 'block':
                return new THREE.BoxGeometry(); // Blok
            case 'ball':
                return new THREE.SphereGeometry(1, 32, 32); // Bola
            case 'can':
                return new THREE.CylinderGeometry(1, 1, 2, 32); // Tin
            case 'cone':
                return new THREE.ConeGeometry(1, 2, 32); // Kon
            default:
                return new THREE.BoxGeometry(); // Bentuk lalai (blok)
        }
    }

    // Fungsi untuk mendapatkan warna rawak
    function getRandomColor() {
        const colors = [0xff5733, 0x33ff57, 0x3357ff, 0xffff33, 0xff33ff];
        return colors[Math.floor(Math.random() * colors.length)];
    }

    // Fungsi untuk mengalihkan ke halaman score.php dengan skor
    function redirectToScorePage() {
        // Menyimpan skor dalam URL untuk digunakan pada halaman score.php
        window.location.href = `score.php?score=${score}`;
    }

    // Event listener untuk pilihan jawapan
    document.querySelectorAll(".option").forEach((button) => {
        button.addEventListener("click", (event) => {
            const selectedAnswer = event.target.dataset.answer;
            checkAnswer(selectedAnswer);
        });
    });

    // Muatkan bentuk pertama apabila permainan bermula
    loadNextShape(level);
});
