<?php
session_start();
require '../../intro/config.php'; 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_SESSION['username'])) {
        die("Error: Username tidak ditemui. Sila log masuk semula.");
    }

    $score = $_POST['score'];
    $username = $_SESSION['username'];

    // Insert or update score
    $stmt = $conn->prepare("INSERT INTO jamdanmasa (username, score) VALUES (?, ?) 
                            ON DUPLICATE KEY UPDATE score = GREATEST(score, VALUES(score))");
    $stmt->bind_param("si", $username, $score);

    if ($stmt->execute()) {
        header("Location: ../../murid6/indexTahun6.php");
        exit;
    } else {
        echo "Error: Tidak dapat menyimpan skor. " . $conn->error;
    }

    $stmt->close();
    $conn->close();
} else {
    echo "Akses tidak sah.";
}
?>
