<?php
session_start();

if (!isset($_SESSION['username'])) {
    header("Location: ../../intro/LoginPelajar.php");
    exit;
}

// Reset score only when coming from index.php (new game start)
if (!isset($_GET['level'])) {
    $_SESSION['score'] = 0;
}

// Set level, default is 1
$level = isset($_GET['level']) ? (int)$_GET['level'] : 1;

$questions = [
    1 => ['question' => 'Pukul berapakah ini?', 'image' => 'clock9.png', 'answer' => '9'],
    2 => ['question' => 'Pukul berapakah ini?', 'image' => 'clock10.png', 'answer' => '10'],
    3 => ['question' => 'Pukul berapakah ini?', 'image' => 'clock11.png', 'answer' => '11'],
    4 => ['question' => 'Pukul berapakah ini?', 'image' => 'clock12.png', 'answer' => '12'],
    5 => ['question' => 'Pukul berapakah ini?', 'image' => 'clock3.png', 'answer' => '3'],
    6 => ['question' => 'Farah bersarapan pada pukul berapa pagi?', 'image' => ['breakfast.png', 'clock8.png'], 'answer' => '8'],
    7 => ['question' => 'Farah makan tengah hari pada pukul berapa?', 'image' => ['lunch.png', 'clock12.png'], 'answer' => '12'],
    8 => ['question' => 'Farah bermain tenis pada pukul berapa petang?', 'image' => ['play.png', 'clock5.png'], 'answer' => '5'],
    9 => ['question' => 'Farah tidur pada pukul berapa malam?', 'image' => ['sleep.png', 'clock9.png'], 'answer' => '9'],
    10 => ['question' => 'Farah bangun pagi pada pukul berapa?', 'image' => ['wake.png', 'clock7.png'], 'answer' => '7']
];

// Function to generate random answer choices
function generateChoices($correctAnswer) {
    $choices = [$correctAnswer];
    while (count($choices) < 4) {
        $randomChoice = rand(1, 12);
        if (!in_array($randomChoice, $choices)) {
            $choices[] = $randomChoice;
        }
    }
    shuffle($choices);
    return $choices;
}

$choices = generateChoices($questions[$level]['answer']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $answer = $_POST['answer'];
    if ($answer === $questions[$level]['answer']) {
        $_SESSION['score'] += 10;
    }

    if ($level < 10) {
        header("Location: game.php?level=" . ($level + 1));
    } else {
        header("Location: score.php?score=" . $_SESSION['score']);
    }
    exit();
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Level <?= $level ?></title>
    <link rel="stylesheet" href="style.css">
    <style>
        .answer-btn {
            background: #4CAF50;
            color: white;
            font-size: 24px;
            font-weight: bold;
            border: none;
            border-radius: 15px;
            padding: 15px 30px;
            cursor: pointer;
            transition: transform 0.2s, background 0.3s;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 120px;
            text-align: center;
            animation: bounce 1.5s infinite;
        }

        .answer-btn:hover {
            background: #45a049;
            transform: scale(1.1);
        }

        .answer-btn:active {
            transform: scale(0.95);
        }

        @keyframes bounce {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }

        .image-container img {
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }
    </style>
</head>
<body>
<video autoplay muted loop class="background-video">
    <source src="backg7.mp4" type="video/mp4">
</video>

<header>
    <div class="score">Score: <?= $_SESSION['score'] ?></div>
    <button class="settings-button" onclick="window.location.href='setting.php'">Tetapan</button>

</header>
<main>
    <div class="game-container">
        <h2>Level <?= $level ?></h2>
        <p class="question"><?= $questions[$level]['question'] ?></p>
        <p class="note">Pilih jawapan yang betul</p>

        <div class="image-container">
            <?php if ($level >= 6): ?>
                <?php foreach ($questions[$level]['image'] as $image): ?>
                    <img src="images/<?= $image ?>" alt="Soalan" class="question-image">
                <?php endforeach; ?>
            <?php else: ?>
                <img src="images/<?= $questions[$level]['image'] ?>" alt="Soalan" class="question-image">
            <?php endif; ?>
        </div>

        <form method="POST" class="answer-form">
            <?php foreach ($choices as $choice): ?>
                <button type="submit" name="answer" value="<?= $choice ?>" class="answer-btn"><?= $choice ?></button>
            <?php endforeach; ?>
        </form>
    </div>
</main>
</body>
</html>

