<?php
session_start();
include_once("../../intro/config.php");

// Soalan dan jawapan
$questions = [
    ["question" => "Siapakah yang merawat orang sakit?", "image" => "img/doktor.jpg", "options" => ["Doktor", "Jururawat", "Pemandu Bas", "Petani"], "answer" => "Doktor"],
    ["question" => "Siapakah yang mengajar di sekolah?", "image" => "img/guru.jpg", "options" => ["Guru", "Juruelektrik", "Pekerja Kilang", "Ahli Politik"], "answer" => "Guru"],
    ["question" => "Siapakah yang memadamkan api?", "image" => "img/bomba.jpg", "options" => ["Bomba", "Polis", "Juruteknik", "Juruukur"], "answer" => "Bomba"],
    ["question" => "Siapakah yang membuat kek dan roti?", "image" => "img/pembuat_kek.jpg", "options" => ["Pembuat Kek", "Tukang Masak", "Petani", "Juruteknik"], "answer" => "Pembuat Kek"],
    ["question" => "Siapakah yang menjaga keselamatan jalan raya?", "image" => "img/police.jpg", "options" => ["Polis", "Doktor", "Juruelektrik", "Guru"], "answer" => "Polis"],
    ["question" => "Siapakah yang menanam padi?", "image" => "img/petani.jpg", "options" => ["Petani", "Nelayan", "Guru", "Doktor"], "answer" => "Petani"],
    ["question" => "Siapakah yang menangkap ikan?", "image" => "img/nelayan.jpg", "options" => ["Nelayan", "Bomba", "Polis", "Juruteknik"], "answer" => "Nelayan"],
    ["question" => "Siapakah yang memperbaiki kereta?", "image" => "img/mekanik.jpg", "options" => ["Mekanik", "Doktor", "Pembuat Kek", "Juruukur"], "answer" => "Mekanik"],
    ["question" => "Siapakah yang merancang bangunan?", "image" => "img/arkitek.jpg", "options" => ["Arkitek", "Jururawat", "Petani", "Ahli Politik"], "answer" => "Arkitek"],
    ["question" => "Siapakah yang menerbangkan kapal terbang?", "image" => "img/pilot.jpg", "options" => ["Juruterbang", "Doktor", "Juruelektrik", "Nelayan"], "answer" => "Juruterbang"],
];

// Simpan soalan dalam sesi jika belum ada
if (!isset($_SESSION['questions'])) {
    $_SESSION['questions'] = $questions;
    $_SESSION['score'] = 0;
    $_SESSION['current_question'] = 0;
}

// Soalan semasa
$current_question_index = $_SESSION['current_question'];
if ($current_question_index < count($questions)) {
    $question = $questions[$current_question_index];
} else {
    header("Location: results.php");
    exit;
}

// Proses jawapan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['answer'])) {
        if ($_POST['answer'] === $question['answer']) {
            $_SESSION['score'] += 10; // Tambah skor
        }
        $_SESSION['current_question']++; // Ke soalan seterusnya
    }

    // Arahkan ke soalan seterusnya
    header("Location: game.php");
    exit;
}

// Acak pilihan jawapan
shuffle($question['options']);  
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jom Kenali Pekerjaan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="score">Skor: <?= $_SESSION['score'] ?>/100</div>
    <div class="main-title">Soalan <?= $current_question_index + 1 ?> dari <?= count($questions) ?></div>

    <div class="game-container">
        <img src="<?= $question['image'] ?>" alt="Question Image" class="question-image">
        <div class="question"><?= $question['question'] ?></div>
        
        <div class="options">
            <?php foreach ($question['options'] as $option): ?>
                <form method="POST">
                    <button name="answer" value="<?= $option ?>"><?= $option ?></button>
                </form>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
