<?php
$questions = [
    ["image" => "img/car.png", "correct" => "Kereta", "options" => ["Kereta", "Motor", "Bas", "Helikopter"]],
    ["image" => "img/motor.png", "correct" => "Motor", "options" => ["Motor", "Kapal Terbang", "Lori", "Bot"]],
    ["image" => "img/aeroplane.png", "correct" => "Kapal Terbang", "options" => ["Kapal Terbang", "Helikopter", "Van", "Kereta"]],
    ["image" => "img/truck.png", "correct" => "Lori", "options" => ["Lori", "Bas", "Kereta api", "Motor"]],
    ["image" => "img/helicopter.png", "correct" => "Helikopter", "options" => ["Helikopter", "Kereta", "Basikal", "Bot"]],
    ["image" => "img/boat.png", "correct" => "Bot", "options" => ["Bot", "Kereta", "Kapal Terbang", "Lori"]],
    ["image" => "img/bas.png", "correct" => "Bas", "options" => ["Bas", "Lori", "Van", "Kereta api"]],
    ["image" => "img/train.png", "correct" => "Kereta api", "options" => ["Kereta api", "Kereta", "Motor", "Helikopter"]],
    ["image" => "img/basikal.png", "correct" => "Basikal", "options" => ["Basikal", "Motor", "Kapal Terbang", "Bas"]],
    ["image" => "img/van.png", "correct" => "Van", "options" => ["Van", "Bas", "Lori", "Kereta"]],
];

$questionIndex = isset($_GET['question']) ? (int)$_GET['question'] : 0;
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;
$message = '';

if ($questionIndex >= count($questions)) {
    header("Location: result.php?score=$score");
    exit;
}

$current = $questions[$questionIndex];
$options = $current['options'];
shuffle($options); // Susunan jawapan rawak

// Periksa jika terdapat jawapan
if (isset($_GET['answer'])) {
    $answer = $_GET['answer'];
    if ($answer === $current['correct']) {
        $message = "TANIAH, ANDA BETUL! MARI KE SOALAN SETERUSNYA.";
        $score += 10; // Tambah 10 untuk jawapan betul
    } else {
        $message = "ANDA SALAH, MARI KE SOALAN SETERUSNYA.";
    }
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pilih Jawapan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body class="game-body">
    <div class="game-header">
        <div class="game-score">
            Skor: <?= $score ?>/100
        </div>
        <div class="game-settings">
            <a href="setting.php" class="game-settings-btn">Tetapan</a>
        </div>
    </div>
    
    <div class="game-container">
        <?php if ($message): ?>
            <div class="game-message">
                <p><?= $message ?></p>
                <a href="game.php?question=<?= $questionIndex + 1 ?>&score=<?= $score ?>" class="game-next-btn">Soalan Seterusnya</a>
            </div>
        <?php else: ?>
            <h1 class="game-title">SOALAN <?= $questionIndex + 1 ?></h1>
            <img src="<?= $current['image'] ?>" alt="Soalan" class="game-image">
            <p class="game-description">Pilih jawapan yang betul:</p>
            <div class="game-choices">
                <?php foreach ($options as $option): ?>
                    <a href="game.php?question=<?= $questionIndex ?>&score=<?= $score ?>&answer=<?= urlencode($option) ?>" class="game-choice">
                        <?= $option ?>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
