<?php
session_start();

// Pastikan pengguna telah log masuk
if (!isset($_SESSION['username'])) {
    header("Location: ../../intro/LoginPelajar.php");
    exit;
}

require_once '../../intro/config.php';

// Check if the score is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $final_score = $_SESSION['score'];
    $username = $_SESSION['username'];

    // Insert the score into the keajaibancuaca table jika username wujud
    if (!empty($username)) {
        $stmt = $conn->prepare("INSERT INTO keajaibancuaca (username, score) VALUES (?, ?)");
        $stmt->bind_param("si", $username, $final_score);
        $stmt->execute();
        $stmt->close();
    }

    // Arahkan ke halaman utama
    header("Location: ../../murid6/indexTahun6.php");
    exit;
}

// Retrieve the final score to display on the page
$final_score = $_SESSION['score'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>Skor Anda</title>
</head>
<body>
    <video id="background-video" autoplay loop muted>
        <source src="video/background.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <audio id="background-music" loop autoplay>
        <source src="audio/background-music.mp3" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>
    <div class="score-container">
        <h1>Tahniah! 🎉</h1>
        <img src="images/minions.gif" alt="Trophy GIF" class="score-image">
        <p class="final-score">Markah Akhir Anda: <span><?php echo $final_score; ?>/100</span></p>
        <form method="POST">
            <button type="submit" class="menu-button">Kembali Ke Halaman Utama</button>
        </form>
    </div>
    <script>
        const music = document.getElementById('background-music');
        music.volume = 0.2; // Laraskan kelantangan
    </script>
</body>
</html>
