<?php
session_start();

// Database connection
require_once '../../intro/config.php';

// Check if the user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: ../../intro/LoginPelajar.php");
    exit();
}

$username = $_SESSION['username'];
$score = $_SESSION['score'];

// Update the score in the database
if (isset($_GET['submit_score'])) {
    // Prepare the SQL query
    $sql = "INSERT INTO membelibelah (username, score) VALUES (?, ?) ON DUPLICATE KEY UPDATE score = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sii", $username, $score, $score);
    
    if ($stmt->execute()) {
        // Score successfully updated
        $_SESSION['score'] = 0; // Reset score after saving to DB
        $_SESSION['question_index'] = 0; // Reset question index for next game
        header("Location: ../../murid6/indexTahun6.php"); // Redirect to homepage after submitting score
        exit();
    } else {
        echo "Error updating score: " . $stmt->error;
    }
}

// Close database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quiz Results</title>
    <link rel="stylesheet" href="style.css">
</head>
<body class="result">

    <!-- All results container with class all-results -->
    <div class="all-results">
        <h2>Game Over</h2>
        <p>Your Score: <?php echo $score . "/100"; ?></p>

        <!-- Button to go back to homepage and submit score -->
        <a href="score.php?submit_score=true" class="back-to-home-button">Kembali Ke Halaman Utama</a>
    </div>

</body>
</html>
