<?php
session_start();

// Semak jika pengguna log masuk
if (!isset($_SESSION['username'])) {
    header("Location: ../../intro/LoginPelajar.php");
    exit();
}

// Sambungan ke database
include('../../intro/config.php');

$username = $_SESSION['username']; // Ambil username dari sesi

// Semak kewujudan username dalam jadual pelajar
$stmt = $conn->prepare("SELECT * FROM pelajar WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc(); // Ambil maklumat pengguna
    $finalScore = isset($_SESSION['score']) ? $_SESSION['score'] : 0;

    // Masukkan skor ke dalam jadual awesomeworld jika skor lebih dari 0
    if ($finalScore > 0) {
        $insertStmt = $conn->prepare("INSERT INTO awesomeworld (username, score, date) VALUES (?, ?, NOW())");
        if ($insertStmt) {
            $insertStmt->bind_param("si", $username, $finalScore);
            $insertStmt->execute();
            $insertStmt->close();
        } else {
            die("Error preparing statement: " . $conn->error);
        }
    }
} else {
    echo "Ralat: Pengguna tidak dijumpai dalam jadual pelajar.";
    exit();
}

// Hapus skor sahaja tanpa menghancurkan sesi pengguna
unset($_SESSION['score']);

// Tutup sambungan
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Result - My Awesome World</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Selamat Datang, <?php echo htmlspecialchars($user['username']); ?>!</h1>
        <h2>Skor Akhir Anda: <?php echo $finalScore; ?> / 100</h2>
        
        <a href="../../murid6/indexTahun6.php" class="home-btn">Kembali ke Halaman Utama</a>
    </div>
</body>
</html>
