<?php
session_start();
require '../../intro/config.php'; // Pastikan config.php mengandungi sambungan ke database

// Semak jika sesi username wujud
if (!isset($_SESSION['username'])) {
    echo "<script>alert('Sila log masuk semula.'); window.location.href='../../login.php';</script>";
    exit;   
}

$username = $_SESSION['username'];
$finalScore = $_SESSION['score'] ?? 0; // Pastikan ada nilai default

// Masukkan skor ke dalam database
$sql = "INSERT INTO akidah6 (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $username, $finalScore);
$stmt->execute();
$stmt->close();

// Hapus sesi tetapi pastikan username masih ada untuk rujukan
unset($_SESSION['score']);
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <video autoplay loop muted class="background-video">
            <source src="backgrr.mp4" type="video/mp4">
        </video>
        <div class="content animate-fade-in">
            <h1 class="animate-bounce">Keputusan Anda</h1>
            <p class="animate-zoom">Skor Akhir: <?= htmlspecialchars($finalScore); ?>/100</p>
            <button onclick="redirectToHome()" class="play-button animate-shake">Kembali Ke Halaman Utama</button>
        </div>
    </div>

    <script>
        function redirectToHome() {
            window.location.href = '../../murid6/indexTahun6.php';
        }
    </script>
</body>
</html>
