const questions = [
    "Adakah kita perlu hormat kepada guru?",
    "Adakah menghormati ibu bapa wajib dilakukan?",
    "Adakah berkata kasar kepada kawan dibenarkan?",
    "Adakah menyapa dengan sopan adalah sikap yang baik?",
    "Adakah membantu ahli keluarga adalah amalan mulia?",
    "Adakah perlu kita berkata terima kasih selepas menerima sesuatu?",
    "Adakah menjerit kepada orang tua itu adab yang baik?",
    "Adakah bergurau dengan cara yang sopan adalah tindakan yang betul?",
    "Adakah menolong rakan yang memerlukan tanda akhlak mulia?",
    "Adakah penting menjaga perkataan ketika bercakap?"
];

const correctAnswers = ["BETUL", "BETUL", "SALAH", "BETUL", "BETUL", "BETUL", "SALAH", "BETUL", "BETUL", "BETUL"];

let currentQuestion = 0;
let score = 0;

const showQuestion = () => {
    const questionContainer = document.getElementById("question-container");
    if (currentQuestion < questions.length) {
        questionContainer.innerHTML = `
            <h2>${questions[currentQuestion]}</h2>
            <button onclick="checkAnswer('BETUL')">BETUL</button>
            <button onclick="checkAnswer('SALAH')">SALAH</button>
        `;
    } else {
        // Pindahkan ke halaman keputusan dengan skor sebagai parameter
        window.location.href = `score.php?score=${score}`;
    }
};


const checkAnswer = (answer) => {
    const feedback = document.getElementById("feedback");

    if (answer === correctAnswers[currentQuestion]) {
        feedback.innerText = "BETUL!";
        feedback.style.color = "green";
        score += 10;
    } else {
        feedback.innerText = "SALAH!";
        feedback.style.color = "red";
    }

    document.getElementById("score").innerText = `Skor: ${score}/100`;

    feedback.style.animation = "fadeInOut 2s";
    setTimeout(() => {
        feedback.innerText = "";
        feedback.style.animation = "";
        currentQuestion++;
        showQuestion();
    }, 1500);
};

window.onload = showQuestion;
