<?php
session_start();
include '../../intro/config.php'; // Connection to your database

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the score from the form
    $score = intval($_POST['score']);

    // Get the username of the currently logged-in user
    $username = $_SESSION['username'] ?? null; // Assuming the username is stored in the session

    if ($username) {
        // Insert the score into the pengembaraanseronok table
        $query = "INSERT INTO pengembaraanseronok (username, score) VALUES (?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("si", $username, $score);

        if ($stmt->execute()) {
            // Redirect to the target page after successful insertion
            header("Location: ../../murid6/indexTahun6.php");
            exit;
        } else {
            echo "Failed to save the score: " . $conn->error;
        }

        $stmt->close();
    } else {
        echo "User not logged in.";
    }
}

$conn->close();
?>
