<?php
session_start();

// Pastikan data sesi wujud
if (!isset($_SESSION['total_score'])) {
    $_SESSION['total_score'] = 0;
}
if (!isset($_SESSION['current_game_score'])) {
    $_SESSION['current_game_score'] = 0;
}

// Tetapkan jumlah soalan per tajuk
$total_questions = 3; // Pastikan ini sesuai dengan jumlah soalan setiap tajuk

// Hadkan skor keseluruhan maksimum 100
$_SESSION['total_score'] = min(100, $_SESSION['total_score']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Permainan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="score-container">
        <h1>Skor Akhir</h1>
        <p>Skor Tajuk Ini: <?= htmlspecialchars($_SESSION['current_game_score']) ?> / <?= $total_questions * 10 ?></p>
        <p>Skor Keseluruhan: <?= htmlspecialchars($_SESSION['total_score']) ?></p>
        <a href="titles.php" class="primary-button">Main Lagi</a>
    </div>
</body>
</html>
