<?php
session_start();

// Define questions and answers for each game title
$games = [
    "Haiwan Liar" => [
        ["Apakah haiwan terpantas di dunia?", "Cheetah", "Harimau", "Singa", "Gajah", "Cheetah"],
        ["Apakah haiwan terbesar di darat?", "Badak", "Harimau", "Gajah", "Jerapah", "Gajah"],
        ["Di manakah habitat beruang kutub?", "Savannah", "Hutan", "Gurun", "Kutub Utara", "Kutub Utara"],
    ],
    "Makanan Haiwan" => [
        ["Apakah makanan utama panda?", "Bamboo", "Buah-buahan", "Daging", "Daun", "Bamboo"],
        ["Apakah makanan kegemaran singa?", "Ikan", "Tumbuhan", "Daging", "Serangga", "Daging"],
        ["Apakah haiwan yang makan serangga?", "Harimau", "Kura-kura", "Singa", "Penguin", "Penguin"],
    ],
    "Tempat Tinggal Haiwan" => [
        ["Di manakah buaya tinggal?", "Pokok", "Air", "Gurun", "Awan", "Air"],
        ["Di manakah ikan paus tinggal?", "Air Tawar", "Air Masin", "Padang Pasir", "Hutan", "Air Masin"],
        ["Di manakah ayam menetap?", "Pokok", "Reban", "Lautan", "Gurun", "Reban"],
    ],
];

// Get the selected game title
$title = isset($_GET['title']) ? $_GET['title'] : '';
if (!isset($games[$title])) {
    header("Location: titles.php");
    exit();
}

// Load or initialize the game state
if (!isset($_SESSION['question_index'])) {
    $_SESSION['question_index'] = 0;
    $_SESSION['current_game_score'] = 0;
}

// Feedback for answer
$feedback = "";
$feedback_class = "";

// Check for answer submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_answer = $_POST['answer'];
    $question_index = $_SESSION['question_index'];
    $current_question = $games[$title][$question_index];
    $correct_answer = $current_question[5];

    // Semak jawapan pengguna
    if ($user_answer === $correct_answer) {
        $feedback = "BETUL";
        $feedback_class = "correct";
        $_SESSION['current_game_score'] += 10; // Tambah skor
    } else {
        $feedback = "SALAH";
        $feedback_class = "incorrect";
    }

    // Kemaskini indeks soalan untuk soalan seterusnya
    $_SESSION['question_index']++;

    // Jika tamat soalan, alihkan ke halaman skor
    if ($_SESSION['question_index'] >= count($games[$title])) {
        // Save total score
        $_SESSION['total_score'] = ($_SESSION['total_score'] ?? 0) + $_SESSION['current_game_score'];
        header("Location: score.php");
        exit();
    }
}

// Get the current question
$question_index = $_SESSION['question_index'];
$current_question = $games[$title][$question_index];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> - Soalan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Top bar -->
    <div class="top-bar">
        <div class="score">Skor: <?= $_SESSION['current_game_score'] ?></div>
        <button class="settings-button">Tetapan</button>
    </div>

    <!-- Game container -->
    <div class="game-container">
        <h1><?= htmlspecialchars($title) ?></h1>
        <h2>Soalan <?= $question_index + 1 ?>:</h2>
        <div class="question-box">
            <p><?= htmlspecialchars($current_question[0]) ?></p>
        </div>

        <!-- Maklum balas (BETUL/SALAH) -->
        <?php if ($feedback): ?>
            <div class="feedback <?= $feedback_class ?>"><?= $feedback ?></div>
        <?php endif; ?>

        <!-- Borang jawapan -->
        <form method="post">
            <?php for ($i = 1; $i <= 4; $i++): ?>
                <button type="submit" name="answer" value="<?= htmlspecialchars($current_question[$i]) ?>" class="answer-button">
                    <?= htmlspecialchars($current_question[$i]) ?>
                </button>
            <?php endfor; ?>
        </form>
    </div>
</body>
</html>
