<?php
session_start();
include('../../intro/config.php'); 

// Dapatkan skor dari URL
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;

// Dapatkan username dari sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'Tetamu';

// Masukkan data ke dalam pangkalan data
$sql = "INSERT INTO rumahKita (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $username, $score);
$stmt->execute();
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Markah Pelajar</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="score-container">
        <h1>Markah Anda</h1>
        <p>Skor: <strong><?= $score ?>/100</strong></p>
        <a href="../../murid5/indexTahun5.php" class="back-button">Kembali ke Permainan</a>
    </div>
</body>
</html>
