<?php
session_start(); // Memastikan sesi dimulai
include '../../intro/config.php'; // Sambungan   pangkalan data

// Soalan dan jawapan
$questions = [
    [
        'question' => 'YANG MANA SATUKAH BUAH EPAL?',
        'audio' => 'audio/epal.mp3',
        'choices' => [
            ['text' => 'Epal', 'image' => 'img/epal.png'],
            ['text' => 'Lobak Merah', 'image' => 'img/carrot.png']
        ],
        'correct' => 0
    ],
    [
        'question' => 'YANG MANA SATUKAH BUAH PISANG?',
        'audio' => 'audio/pisang.mp3',
        'choices' => [
            ['text' => 'Timun', 'image' => 'img/timun.png'],
            ['text' => 'Pisang', 'image' => 'img/pisang.png']
        ],
        'correct' => 1
    ],
    [
        'question' => 'YANG MANA SATUKAH BUAH TOMATO?',
        'audio' => 'audio/tomato.mp3',
        'choices' => [
            ['text' => 'Strawberi', 'image' => 'img/strawberry.png'],
            ['text' => 'Tomato', 'image' => 'img/tomato.png']
        ],
        'correct' => 1
    ],
    [
        'question' => 'YANG MANA SATUKAH SAYUR KUBIS?',
        'audio' => 'audio/kubis.mp3',
        'choices' => [
            ['text' => 'Kubis', 'image' => 'img/kubis.png'],
            ['text' => 'Cili', 'image' => 'img/cili.png']
        ],
        'correct' => 0
    ],
    [
        'question' => 'YANG MANA SATUKAH BUAH NENAS?',
        'audio' => 'audio/nenas.mp3',
        'choices' => [
            ['text' => 'Betik', 'image' => 'img/betik.png'],
            ['text' => 'Nanas', 'image' => 'img/nenas.png']
        ],
        'correct' => 1
    ],
    [
        'question' => 'YANG MANA SATUKAH SAYUR CENDAWAN?',
        'audio' => 'audio/cendawan.mp3',
        'choices' => [
            ['text' => 'Brokoli', 'image' => 'img/brokoli.png'],
            ['text' => 'Cendawan', 'image' => 'img/shitake.png']
        ],
        'correct' => 1
    ],
    [
        'question' => 'YANG MANA SATUKAH SAYUR TIMUN?',
        'audio' => 'audio/timun.mp3',
        'choices' => [
            ['text' => 'Timun', 'image' => 'img/timun.png'],
            ['text' => 'Terung', 'image' => 'img/terung.png']
        ],
        'correct' => 0
    ],
    [
        'question' => 'YANG MANA SATUKAH SAYUR BAYAM?',
        'audio' => 'audio/bayam.mp3',
        'choices' => [
            ['text' => 'Bayam', 'image' => 'img/bayam.png'],
            ['text' => 'Sawi', 'image' => 'img/sawi.png']
        ],
        'correct' => 0
    ],
    [
        'question' => 'YANG MANA SATUKAH SAYUR CILI?',
        'audio' => 'audio/cili.mp3',
        'choices' => [
            ['text' => 'Cili', 'image' => 'img/cili.png'],
            ['text' => 'Lobak Merah', 'image' => 'img/carrot.png']
        ],
        'correct' => 0
    ],
    [
        'question' => 'YANG MANA SATUKAH BUAH JAGUNG?',
        'audio' => 'audio/jagung.mp3',
        'choices' => [
            ['text' => 'Jagung', 'image' => 'img/jagung.png'],
            ['text' => 'Bayam', 'image' => 'img/bayam.png']
        ],
        'correct' => 0
    ]
];

// Parameter kuiz
$currentQuestion = isset($_GET['question']) ? intval($_GET['question']) : -1;
$totalQuestions = count($questions);
$score = isset($_GET['score']) ? intval($_GET['score']) : 0;

// Proses jawapan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $answer = isset($_POST['answer']) ? intval($_POST['answer']) : -1;
    $correct = $questions[$currentQuestion]['correct'];

    // If answer is correct, increment score and proceed to next question
    if ($answer === $correct) {
        $score += 10;
    }
    $currentQuestion++; // Proceed to next question

    if ($currentQuestion < $totalQuestions) {
        // Soalan seterusnya
        header("Location: ?question=$currentQuestion&score=$score");
        exit;
    } else {
        // Tamat kuiz, alihkan ke score.php
        header("Location: score.php?score=$score&total=$totalQuestions");
        exit;
    }
}

?>

<!DOCTYPE html>
<html lang="ms">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuiz Interaktif</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <video class="background-video" autoplay muted loop>
        <source src="vid.mp4" type="video/mp4">
        Penyemak imbas anda tidak menyokong video.
    </video>

    <div class="container">
        <?php if (!isset($_GET['question']) && !isset($_GET['save'])): ?>
            <!-- Halaman Menu -->
            <div class="menu-title">Selamat Datang ke Kuiz Interaktif!</div>
            <p>Uji pengetahuan anda tentang buah-buahan dan sayur-sayuran.</p>
            <a class="play-btn" href="?question=0&score=0">Main</a>
        <?php elseif (isset($_GET['save'])): ?>
            <!-- Simpan Skor -->
            <div class="menu-title">Kuiz Tamat!</div>
            <p>Skor anda: <?= htmlspecialchars($_GET['score']) ?> / <?= $totalQuestions * 10 ?></p>
            <form method="POST" action="">
                <label for="name">Masukkan Nama Anda:</label>
                <input type="text" id="name" name="name" required>
                <button type="submit">Simpan Skor</button>
            </form>
        <?php else: ?>
            <!-- Soalan Kuiz -->
            <?php $current = $questions[$currentQuestion]; ?>
            <div class="score">Skor: <?= htmlspecialchars($score) ?> / <?= $totalQuestions * 10 ?></div>
            <div class="question"><?= htmlspecialchars($current['question']) ?></div>
            
            

            <?php if (isset($errorMessage)): ?>
                <div class="error-message"><?= $errorMessage ?></div>
            <?php endif; ?>

            <form method="POST" class="choices">
                <?php foreach ($current['choices'] as $index => $choice): ?>
                    <button class="choice" name="answer" value="<?= $index ?>" type="submit">
                        <img src="<?= htmlspecialchars($choice['image']) ?>" alt="<?= htmlspecialchars($choice['text']) ?>">
                        <div><?= htmlspecialchars($choice['text']) ?></div>
                    </button>
                <?php endforeach; ?>
            </form>
            <br>
            <div>Soalan <?= $currentQuestion + 1 ?> daripada <?= $totalQuestions ?></div>
        <?php endif; ?>
    </div>
</body>

</html>
