<?php
session_start();

// Sambungkan ke pangkalan data
require_once '../../intro/config.php';

// Ambil username dari sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : "Unknown";

// Ambil skor dari URL atau tetapkan ke 0 jika tiada
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;

// Simpan skor ke dalam pangkalan data
$sql = "INSERT INTO bajucantik (username, score, `date`, masa_mula) VALUES (?, ?, CURDATE(), NOW())";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("si", $username, $score);
        if ($stmt->execute()) {
            $message = "Skor berjaya disimpan!";
        } else {
            $message = "Ralat menyimpan skor: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = "Ralat penyediaan pernyataan: " . $conn->error;
    }




// Tutup sambungan hanya selepas semua operasi selesai
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Akhir</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="end-container">
        <h1>🌟 Tahniah! 🎉</h1>
        <p>Anda telah menyelesaikan permainan.</p>
        <p><strong>Skor Akhir: <?= $score ?> /100</strong></p>
        <div class="stars">
            <!-- Anda boleh tambahkan logik untuk paparkan bintang berdasarkan skor -->
        </div>
        <p><?= $message ?></p>
        <a href="../../murid5/indexTahun5.php" class="restart-btn">Kembali ke Menu</a>
    </div>
</body>
</html>
