<?php
session_start();

$questions = [
    ["images" => ["images/besar1.jpg", "images/kecil1.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Tebal", "Nipis", "Besar", "Kecil"], "answers" => ["Besar", "Kecil"]],
    ["images" => ["images/tebal1.jpg", "images/nipis1.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Tinggi", "Pendek", "Tebal", "Nipis"], "answers" => ["Tebal", "Nipis"]],
    ["images" => ["images/besar2.jpg", "images/kecil2.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Besar", "Kecil", "Tebal", "Nipis"], "answers" => ["Besar", "Kecil"]],
    ["images" => ["images/tinggi1.jpg", "images/rendah1.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Panjang", "Pendek", "Tinggi", "Rendah"], "answers" => ["Tinggi", "Rendah"]],
    ["images" => ["images/besar3.jpg", "images/kecil3.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Besar", "Kecil", "Tinggi", "Rendah"], "answers" => ["Besar", "Kecil"]],
    ["images" => ["images/panjang1.jpg", "images/pendek1.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Panjang", "Pendek", "Tinggi", "Rendah"], "answers" => ["Panjang", "Pendek"]],
    ["images" => ["images/tinggi2.jpg", "images/rendah2.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Tebal", "Nipis", "Tinggi", "Rendah"], "answers" => ["Tinggi", "Rendah"]],
    ["images" => ["images/besar4.jpg", "images/kecil4.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Besar", "Kecil", "Tebal", "Nipis"], "answers" => ["Besar", "Kecil"]],
    ["images" => ["images/tinggi3.jpg", "images/rendah3.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Rendah", "Tinggi", "Pendek", "Lebar"], "answers" => ["Tinggi", "Rendah"]],
    ["images" => ["images/tebal2.jpg", "images/nipis2.jpg"], "question" => "Pilih lawan bagi kedua-dua bentuk ini?", "options" => ["Tebal", "Nipis", "Besar", "Kecil"], "answers" => ["Tebal", "Nipis"]]
];

if (!isset($_SESSION['question_index'])) {
    $_SESSION['question_index'] = 0;
    $_SESSION['score'] = 0;
    $_SESSION['isCorrect'] = null;
}

$currentQuestion = $questions[$_SESSION['question_index']];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['answers'])) {
        $selected = $_POST['answers'];
        sort($selected);
        $correct = $currentQuestion['answers'];
        sort($correct);

        if ($selected === $correct) {
            $_SESSION['score'] += 10;
            $_SESSION['isCorrect'] = true;
        } else {
            $_SESSION['isCorrect'] = false;
        }

        // Simpan jawapan dalam sesi dan teruskan ke langkah seterusnya hanya bila pengguna tekan "Seterusnya"
        $_SESSION['show_result'] = true;
    } elseif (isset($_POST['next'])) {
        $_SESSION['question_index']++;
        $_SESSION['isCorrect'] = null;
        $_SESSION['show_result'] = false;

        if ($_SESSION['question_index'] >= count($questions)) {
            header('Location: score.php');
            exit;
        }

        $currentQuestion = $questions[$_SESSION['question_index']];
    }
}

// Redirect to next question automatically if the answer is wrong
if (isset($_SESSION['isCorrect']) && $_SESSION['isCorrect'] === false) {
    $_SESSION['question_index']++;
    $_SESSION['isCorrect'] = null;
    $_SESSION['show_result'] = false;

    if ($_SESSION['question_index'] >= count($questions)) {
        header('Location: score.php');
        exit;
    }

    $currentQuestion = $questions[$_SESSION['question_index']];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="game-header">
    <div class="score-display">Skor: <?php echo $_SESSION['score']; ?>/100</div>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@700&display=swap" rel="stylesheet">
    <button class="settings-button" onclick="window.location.href='setting.php';">Tetapan</button>
</div>

<div class="game-container fade-in">
    <div class="question-number">
        Soalan: <?php echo ($_SESSION['question_index'] + 1); ?> / <?php echo count($questions); ?>
    </div>
    <h2 class="question-text"><?php echo $currentQuestion['question']; ?></h2>

    <div class="question-images">
        <?php foreach ($currentQuestion['images'] as $image): ?>
            <img src="<?php echo $image; ?>" alt="Question Image" class="question-image">
        <?php endforeach; ?>
    </div>

    <?php if (!isset($_SESSION['show_result']) || $_SESSION['show_result'] === false): ?>
        <form method="POST" class="answer-form">
            <div class="answer-options">
                <?php foreach ($currentQuestion['options'] as $option): ?>
                    <label class="option-label">
                        <input type="checkbox" name="answers[]" value="<?php echo $option; ?>" class="answer-checkbox">
                        <?php echo $option; ?>
                    </label>
                <?php endforeach; ?>
            </div><br>
            <button type="submit" class="submit-button">Hantar</button>
        </form>
    <?php else: ?>
        <div class="result-display">
            <?php if ($_SESSION['isCorrect'] === true): ?>
                <div class="correct-answer">Betul! Anda mendapat 10 mata.</div>
            <?php elseif ($_SESSION['isCorrect'] === false): ?>
                <div class="wrong-answer">Salah! Jawapan yang betul ialah: 
                    <?php echo implode(" dan ", $currentQuestion['answers']); ?>.
                </div>
            <?php endif; ?>
        </div>
        <form method="POST">
            <button type="submit" name="next" class="next-question-button">Soalan Seterusnya</button>
        </form>
    <?php endif; ?>
</div>

<script>
    const checkboxes = document.querySelectorAll('.answer-checkbox');
    checkboxes.forEach((checkbox) => {
        checkbox.addEventListener('change', () => {
            const checkedBoxes = document.querySelectorAll('.answer-checkbox:checked');
            if (checkedBoxes.length > 2) {
                alert('Pilih 2 Jawapan Sahaja');
                checkbox.checked = false;
            }
        });
    });
</script>
</body>
</html>
