<?php
session_start();
include '../../intro/config.php'; // Database connection file

// Check if the user is logged in
if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

// Get the username from the session
$username = $_SESSION['username'];

// Reset the score when "Kembali ke Halaman Utama" is clicked
if (isset($_GET['reset']) && $_GET['reset'] == 'true') {
    // Save the score to the database before resetting
    if (isset($_SESSION['score']) && $_SESSION['score'] > 0) {
        $score = $_SESSION['score'];

        // Insert the score into the tambahtolak table
        $stmt = $conn->prepare("INSERT INTO tambahtolak (username, score) VALUES (?, ?)");
        $stmt->bind_param("si", $username, $score);
        $stmt->execute();
        $stmt->close();
    }

    // Reset the session score
    $_SESSION['score'] = 0;

    // Redirect to the new main page
    header('Location: ../../murid5/indexTahun5.php');
    exit();
}

// Retrieve the current score
$score = isset($_SESSION['score']) ? $_SESSION['score'] : 0;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Permainan</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .button {
            display: inline-block;
            padding: 10px 20px;
            font-size: 16px;
            color: #fff;
            background-color: #4CAF50; /* Green */
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
        }

        .button:hover {
            background-color: #45a049; /* Darker green */
        }
    </style>
</head>
<body class="score-page">
    <h1>Skor Anda</h1>
    <p>Skor Anda adalah: <?php echo $score; ?>/100</p>
    <!-- Button to reset the score and go to the new main page -->
    <a href="score.php?reset=true" class="button">Kembali ke Halaman Utama</a>
</body>
</html>
