<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION['username'])) {
    echo "Ralat: Pengguna tidak log masuk.";
    exit;
}

// Retrieve the user's name or username from the session
$name = isset($_SESSION['name']) ? htmlspecialchars($_SESSION['name']) : htmlspecialchars($_SESSION['username']);
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mari Mengenal Bentuk</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <div id="score" class="score">Markah: 0/100</div>
        <button class="settings-button" onclick="location.href='setting.php'">Tetapan</button>
        <h1>Bentuk apakah ini?</h1>
        <div id="shape-container"></div>
        <div id="choices" class="choices"></div>
        <div id="result" class="result"></div>
        <p class="level">Level: 1</p>

        <!-- Audio Element -->
        <audio id="backgroundMusic" autoplay loop muted>
            <source src="backgroundSong.mp3" type="audio/mpeg">
            Your browser does not support the audio element.
        </audio>
    </div>

    <script>
        let correctAnswer = '';
        let score = 0;
        let currentLevel = 1;

        const shapes = [
            { name: 'Bintang', image: 'image/bintang1.png' },
            { name: 'Bujur', image: 'image/bujur.png' },
            { name: 'Bulat', image: 'image/bulat1.png' },
            { name: 'Hati', image: 'image/hati1.png' },
            { name: 'Segi Empat', image: 'image/segiempat1.png' },
            { name: 'Segi Empat Tepat', image: 'image/segiempattepat1.png' },
            { name: 'Segi Tiga', image: 'image/segitiga1.png' },
            { name: 'Segi Empat Tepat', image: 'image/segiempattepat2.png' },
            { name: 'Segi Empat', image: 'image/segiempat2.png' },
            { name: 'Segi tiga', image: 'image/segitiga2.png' }
        ];

        function updateScore() {
            document.getElementById('score').textContent = `Markah: ${score}/100`;
        }

        function generateQuestion() {
            const randomIndex = Math.floor(Math.random() * shapes.length);
            const selectedShape = shapes[randomIndex];

            correctAnswer = selectedShape.name;
            document.getElementById('shape-container').innerHTML = 
                `<img src="${selectedShape.image}" alt="${selectedShape.name}" style="width:150px;height:150px;margin-top:20px;">`;

            const choices = new Set();
            while (choices.size < 3) {
                const randomChoice = shapes[Math.floor(Math.random() * shapes.length)].name;
                if (randomChoice !== correctAnswer) choices.add(randomChoice);
            }
            choices.add(correctAnswer);

            const choicesArray = [...choices].sort(() => Math.random() - 0.5);
            const choicesHTML = choicesArray.map(choice => {
                return `<button class="button">${choice}</button>`;
            }).join('');
            document.getElementById('choices').innerHTML = choicesHTML;

            document.querySelectorAll('.button').forEach(button => {
                button.addEventListener('click', (event) => {
                    checkAnswer(event.target.textContent);
                });
            });
        }

        function checkAnswer(selectedAnswer) {
    const result = document.getElementById('result');
    if (selectedAnswer === correctAnswer) {
        score += 10; // Tambah 10 markah untuk jawapan betul
        result.textContent = 'Betul! Jawapan anda tepat!';
        updateScore();
    } else {
        result.textContent = 'Salah!';
    }

    // Bergerak ke soalan seterusnya atau ke score.php selepas 2 saat
    setTimeout(() => {
        currentLevel++;
        if (currentLevel > 10) {
            // Simpan markah ke dalam sesi atau teruskan ke score.php
            window.location.href = `score.php?score=${score}`; // Redirect ke score.php dengan markah sebagai parameter
        } else {
            document.querySelector('.level').textContent = `Level: ${currentLevel}`;
            generateQuestion(); // Jana soalan baru untuk level seterusnya
        }
    }, 2000); // Tunggu 2 saat sebelum ke soalan seterusnya atau halaman skor
}

            document.addEventListener('DOMContentLoaded', () => {
                const music = document.getElementById('backgroundMusic');
                setTimeout(() => {
                    music.muted = false;
                    music.play().catch(error => console.error("Muzik tidak dapat dimainkan:", error));
                }, 500); // Unmute after 500ms

                updateScore(); // Display initial score
                generateQuestion(); // Call function to generate the first question
            });
        </script>
</body>
</html>