<?php
session_start();

// Include the database connection file
include('../../intro/config.php');

// Check if all required parameters are received
if (!isset($_GET['username'], $_GET['score'])) {
    die("Ralat: Data tidak lengkap. Pastikan username dan score dihantar.");
}

// Retrieve data from URL parameters
$username = htmlspecialchars($_GET['username']); // Prevent XSS attacks
$score = intval($_GET['score']); // Ensure the score is an integer

// Debugging: Check if the received data is valid
if (empty($username) || $score <= 0) {
    die("Ralat: Data tidak sah. Username: $username, Score: $score");
}

// Insert data into the `kenalnombor` table
$sql = "INSERT INTO kenalnombor (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);

// Check if statement preparation was successful
if (!$stmt) {
    die("Ralat penyediaan pernyataan: " . $conn->error);
}

// Bind parameters and execute the statement
$stmt->bind_param("si", $username, $score); // "s" for string, "i" for integer
if ($stmt->execute()) {
    echo "Markah telah disimpan dengan jayanya!";
} else {
    echo "Ralat: " . $stmt->error;
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
