<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mari Kenal Nombor</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

<div class="status-bar">
    <div id="score" class="score">Markah: 0/100</div>
    <button class="button-settings" onclick="location.href='setting.php'">⚙️ Tetapan</button>
</div>

<div class="container">
    <div class="question" id="question">Apa nombor ini?</div>
    <div class="choices" id="choices"></div>
    <div class="result" id="result"></div>
    <div class="level" id="level">Level: 1</div>
</div>

<audio id="backgroundMusic" loop>
    <source src="backgroundSong.mp3" type="audio/mpeg">
    Your browser does not support the audio element.
</audio>

<!-- Add new audio element for the question sound -->
<audio id="questionSound" src="sound.mp3" type="audio/mpeg"></audio>

<script>
    let correctAnswer = 0;
    let score = 0;
    let currentLevel = 1;

    // Function to update score display
    function updateScore() {
        document.getElementById('score').textContent = `Markah: ${score}/100`;
    }

    // Function to convert numbers to words
    function numberToWords(num) {
        const words = [
            'satu', 'dua', 'tiga', 'empat', 'lima',
            'enam', 'tujuh', 'lapan', 'sembilan', 'sepuluh',
            'sebelas', 'dua belas', 'tiga belas', 'empat belas',
            'lima belas', 'enam belas', 'tujuh belas', 'lapan belas',
            'sembilan belas', 'dua puluh'
        ];
        return num <= 20 ? words[num - 1] : num.toString();
    }

    // Function to generate a question
    function generateQuestion() {
        const maxNumber = 20; // Set maximum number to 20
        
        correctAnswer = Math.floor(Math.random() * maxNumber) + 1;
        document.getElementById('question').textContent = `Apa nombor ini: ${correctAnswer}?`;

        // Play the sound for the question
        const questionSound = document.getElementById('questionSound');
        questionSound.play().catch(() => console.log("Suara tidak dimainkan"));

        const choices = new Set();
        while (choices.size < 3) {
            const randomNum = Math.floor(Math.random() * maxNumber) + 1;
            if (randomNum !== correctAnswer) choices.add(randomNum);
        }
        choices.add(correctAnswer);

        const choicesArray = [...choices].sort(() => Math.random() - 0.5);
        const choicesHTML = choicesArray.map(
            choice => `<button class="button" onclick="checkAnswer(${choice})">${numberToWords(choice)}</button>`
        ).join('');
        document.getElementById('choices').innerHTML = choicesHTML;
    }

    // Function to check the answer
    function checkAnswer(selectedAnswer) {
        const result = document.getElementById('result');
        if (selectedAnswer === correctAnswer) {
            score += 10; // Add 10 points for a correct answer
            result.textContent = 'Betul! Jawapan anda tepat!';
            updateScore();
            setTimeout(() => {
                currentLevel++;
                if (currentLevel > 10) {
                    // Redirect to score.php after completing all levels
                    window.location.href = `score.php?score=${score}`;
                } else {
                    document.getElementById('level').textContent = `Level: ${currentLevel}`;
                    generateQuestion(); // Generate a new question for the next level
                }
            }, 2000); // Wait 2 seconds before moving to the next level
        } else {
            result.textContent = 'Salah, teruskan ke soalan seterusnya.';
            setTimeout(() => {
                currentLevel++;
                if (currentLevel > 10) {
                    // Redirect to score.php after completing all levels
                    window.location.href = `score.php?score=${score}`;
                } else {
                    document.getElementById('level').textContent = `Level: ${currentLevel}`;
                    generateQuestion(); // Generate a new question for the next level
                }
            }, 2000); // Wait 2 seconds before moving to the next question
        }
    }

    // When the page loads
    document.addEventListener('DOMContentLoaded', () => {
        const music = document.getElementById('backgroundMusic');
        music.play().catch(() => console.log("Muzik tidak dimainkan"));
        updateScore(); // Display initial score
        generateQuestion(); // Call function to generate the first question
    });
</script>

</body>
</html>
