<?php
// Mulakan sesi PHP
session_start();

// Import fail sambungan ke pangkalan data
require '../../intro/config.php'; // Pastikan fail ini mempunyai sambungan $conn

// Periksa sambungan
if ($conn->connect_error) {
    file_put_contents('debug_log.txt', "Database connection failed: " . $conn->connect_error . "\n", FILE_APPEND);
    exit();
}

// Semak jika sesi mempunyai username
if (!isset($_SESSION['username'])) {
    file_put_contents('debug_log.txt', "Sesi tidak mempunyai username.\n", FILE_APPEND);
    header("Location: ../../murid5/indexTahun5.php");
    exit();
}

// Ambil username dari sesi
$sesiUsername = $_SESSION['username'];

// Pastikan username wujud dalam jadual `pelajar`
$checkUserQuery = "SELECT username FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($checkUserQuery);
$stmt->bind_param("s", $sesiUsername);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    file_put_contents('debug_log.txt', "Username tidak wujud: $sesiUsername\n", FILE_APPEND);
    header("Location: ../../murid5/indexTahun5.php");
    exit();
}

// Dapatkan data daripada JSON POST atau fallback kepada $_POST
$data = json_decode(file_get_contents("php://input"), true);
if (!$data && !empty($_POST)) {
    $data = $_POST; // Fallback jika data JSON tiada
}

// Log data mentah untuk debugging
file_put_contents('debug_log.txt', "Raw Input: " . file_get_contents("php://input") . "\n", FILE_APPEND);
file_put_contents('debug_log.txt', "POST Data: " . print_r($_POST, true) . "\n", FILE_APPEND);
file_put_contents('debug_log.txt', "Parsed Data: " . print_r($data, true) . "\n", FILE_APPEND);

// Pastikan data `score` diterima
if (isset($data['score'])) {
    $score = (int) $data['score'];

    // Simpan data ke dalam jadual `haiwankecil`
    $sql = "INSERT INTO haiwankecil (username, score) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $sesiUsername, $score);

    if (!$stmt->execute()) {
        file_put_contents('debug_log.txt', "Gagal memasukkan data: " . $stmt->error . "\n", FILE_APPEND);
    }
} else {
    // Simpan log untuk ralat data tidak lengkap
    file_put_contents('debug_log.txt', "Data tidak lengkap.\n", FILE_APPEND);
}

// Tutup sambungan
$conn->close();

// Redirect ke aplikasi pembelajaran
header("Location: ../../murid5/indexTahun5.php");
exit();
?>
