<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Akhir</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>Skor Akhir</h1>
    </header>
    <main>
        <div class="score-container">
            <h2>Skor Anda:</h2>
            <h1 id="final-score"></h1>
        </div>
        <button class="button-score" onclick="saveScore()">Kembali Ke Halaman Utama</button>
    </main>
    <script>
        // Ambil skor dari sessionStorage
        const finalScore = parseInt(sessionStorage.getItem('score')) || 0;
        const username = sessionStorage.getItem('username') || "Tanpa Nama"; // Username boleh diambil semasa log masuk
        document.getElementById('final-score').textContent = `${finalScore} / 100`;

        // Fungsi untuk simpan skor ke pangkalan data
        function saveScore() {
            fetch('save_score.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ username: username, score: finalScore })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Reset session storage dan alihkan ke level1.php
                    sessionStorage.setItem('score', 0);
                    window.location.href = '../../murid5/indexTahun5.php';
                } else {
                    alert('Gagal menyimpan skor: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Ralat:', error);
                alert('Ralat semasa menyimpan skor.');
            });
        }
    </script>
</body>
</html>
