<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 8 - Kuiz Wudhu</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <button class="settings-button" onclick="alert('Tetapan akan muncul di halaman lain')">Tetapan</button>
    </header>
    <main>
        <h1>Kuiz Akhir: Proses Wudhu</h1>
        <p>Video ini menunjukkan langkah-langkah wudhu sebelum solat:</p>
        
        <!-- Video sebagai elemen utama -->
        <video width="640" height="480" controls class="video-container">
            <source src="gambar/wudhu.mp4" type="video/mp4">
            Video anda tidak disokong oleh penyemak imbas.
        </video>

        <br><br>

        <p>Langkah pertama mengambil wuduk</p>
        <div class="options-8">
            <button onclick="checkAnswer(this, 'A')">A. Melakukan niat sebelum memulakan wudhu</button>
            <button onclick="checkAnswer(this, 'B')">B. Membasuh anggota yang ditentukan dengan niat</button>
            <button onclick="checkAnswer(this, 'C')">C. Berwudhu tanpa perlu mengikuti syarat</button>
            <button onclick="checkAnswer(this, 'D')">D. Wudhu hanya untuk bersihkan tangan sebelum makan</button>
            <button onclick="checkAnswer(this, 'E')">E. Membasuh kaki tanpa perlu tangan dan wajah</button>
        </div>
        
        <p id="feedback" style="font-size: 18px; font-weight: bold; margin-top: 20px;"></p>
    </main>
    
    <script>
        // Ambil skor semasa dari sessionStorage, atau tetapkan ke 0 jika belum ada
        let score = parseInt(sessionStorage.getItem('score')) || 0;

        // Paparkan skor semasa pada elemen #score
        const scoreDisplay = document.getElementById('score');
        scoreDisplay.textContent = score;

        // Fungsi untuk periksa jawapan
        function checkAnswer(button, answer) {
            const correctAnswer = 'A';
            const feedback = document.getElementById('feedback');

            if (answer === correctAnswer) {
                feedback.textContent = 'Betul! Membasuh anggota dengan niat adalah langkah pertama wudhu.';
                feedback.style.color = 'green';
                button.style.backgroundColor = 'green';

                // Tambah skor jika jawapan betul
                score += 10; 
                sessionStorage.setItem('score', score); // Simpan skor baru ke sessionStorage
            } else {
                feedback.textContent = 'Salah. Cuba lagi.';
                feedback.style.color = 'red';
                button.style.backgroundColor = 'red';
            }

            // Alihkan ke score.php selepas 1 saat
            setTimeout(() => {
                window.location.href = 'score.php';
            }, 1000);
        }
    </script>
</body>
</html>