<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 7 - Kuiz Niat Solat</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <button class="settings-button" onclick="location.href='settings.php'">Tetapan</button>
    </header>
    <main>
        <h1>Kuiz: Niat Solat</h1>
        <p>Soalan: Apakah niat yang kita ucapkan sebelum solat Zuhur?</p><br>
        <img src="gambar/niatsolat.jpg" alt="Solat" class="quiz-image"><br><br>
        <div class="options">
            <button onclick="checkAnswer(this, 'A')">A. Sahaja aku sembahyang fardhu subuh dua rakaat tunai kerana Allah Ta'ala</button>
            <button onclick="checkAnswer(this, 'B')">B. Sahaja aku sembahyang fardhu zohor empat rakaat tunai kerana Allah Ta'ala</button>
            <button onclick="checkAnswer(this, 'C')">C. Sahaja aku sembahyang fardhu asar empat rakaat tunai kerana Allah Ta'ala</button>
            <button onclick="checkAnswer(this, 'D')">D. Sahaja aku sembahyang fardhu magrib tiga rakaat tunai kerana Allah Ta'ala</button>
            <button onclick="checkAnswer(this, 'E')">E. Sahaja aku sembahyang fardhu isyak empat rakaat tunai kerana Allah Ta'ala</button>
        </div>
        <p id="feedback" style="font-size: 18px; font-weight: bold; margin-top: 20px;"></p>
    </main>
    <script>
        // Ambil skor semasa dari sessionStorage, atau tetapkan ke 0 jika belum ada
        let score = parseInt(sessionStorage.getItem('score')) || 0;

        // Paparkan skor semasa pada elemen #score
        const scoreDisplay = document.getElementById('score');
        scoreDisplay.textContent = score;

        // Fungsi untuk periksa jawapan
        function checkAnswer(button, answer) {
            const correctAnswer = 'B';
            const feedback = document.getElementById('feedback');

            if (answer === correctAnswer) {
                feedback.textContent = 'Betul! itu lah lafaz niat zuhur bahasa melayu.';
                feedback.style.color = 'green';
                button.style.backgroundColor = 'green';

                // Tambah skor jika jawapan betul
                score += 20; // Tambah 20 mata untuk jawapan betul
                sessionStorage.setItem('score', score); // Simpan skor baru ke sessionStorage
            } else {
                feedback.textContent = 'Salah. Cuba lagi.';
                feedback.style.color = 'red';
                button.style.backgroundColor = 'red';
            }

            // Alihkan ke level8.php selepas 1 saat
            setTimeout(() => {
                window.location.href = 'level8.php';
            }, 1000);

            // Kemas kini paparan skor
            scoreDisplay.textContent = score;
        }
    </script>
</body>
</html>
