<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 6 - Kuiz</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <button class="settings-button" onclick="location.href='settings.php'">Tetapan</button>
    </header>
    <main>
        <h1>Kuiz Rawak Tentang Ibadah</h1>
        <p>Soalan: Sebelum solat, kita mesti mengambil?</p><br>
        <img src="gambar/wudhu.png" alt="wudhu" class="quiz-image"><br><br>
        <div class="options">
            <button onclick="checkAnswer(this, 'A')" 
                    onmouseover="playSound('audio/air minuman.m4a')">A. 🍹 Air minum</button>
            <button onclick="checkAnswer(this, 'B')" 
                    onmouseover="playSound('audio/permainan.m4a')">B. 🎮 Permainan</button>
            <button onclick="checkAnswer(this, 'C')" 
                    onmouseover="playSound('audio/wuduk.m4a')">C. 💦 Wuduk</button>
            <button onclick="checkAnswer(this, 'D')" 
                    onmouseover="playSound('audio/duit.m4a')">D. 💰 Duit</button>
            <button onclick="checkAnswer(this, 'E')" 
                    onmouseover="playSound('audio/makanan.m4a')">E. 🍪 Makanan</button>
        </div>
        
        <p id="feedback" style="font-size: 18px; font-weight: bold; margin-top: 20px;"></p>
    </main>
    <script>
        // Ambil skor semasa dari sessionStorage, atau tetapkan ke 0 jika belum ada
        let score = parseInt(sessionStorage.getItem('score')) || 0;

        // Paparkan skor semasa pada elemen #score
        const scoreDisplay = document.getElementById('score');
        scoreDisplay.textContent = score;

        // Fungsi untuk mainkan bunyi
        function playSound(file) {
            const audio = new Audio(file);
            audio.play();
        }

        // Fungsi untuk periksa jawapan
        function checkAnswer(button, answer) {
            const correctAnswer = 'C';
            const feedback = document.getElementById('feedback');

            if (answer === correctAnswer) {
                feedback.textContent = 'Betul! sebelum kita solat kita haruslah mengambil WUDHU';
                feedback.style.color = 'green';
                button.style.backgroundColor = 'green';

                // Tambah skor jika jawapan betul
                score += 20; // Tambah 20 mata untuk jawapan betul
                sessionStorage.setItem('score', score); // Simpan skor baru ke sessionStorage
            } else {
                feedback.textContent = 'Salah. Cuba lagi.';
                feedback.style.color = 'red';
                button.style.backgroundColor = 'red';
            }

            // Alihkan ke level7.php selepas 1 saat
            setTimeout(() => {
                window.location.href = 'level7.php';
            }, 1000);

            // Kemas kini paparan skor
            scoreDisplay.textContent = score;
        }
    </script>
</body>
</html>
