<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 5 - Kuiz</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <button class="settings-button" onclick="location.href='settings.php'">Tetapan</button>
    </header>
    <main>
        <h1>Kuiz Rawak Tentang Ibadah</h1>
        <p>Soalan: Apa nama rumah ibadah untuk solat?</p><br>
        <img src="gambar/pergimasjid.png" alt="masjid" class="quiz-image"><br><br>
        <div class="options">
            <button onclick="checkAnswer(this, 'A')" 
                    onmouseover="playSound('audio/masjid.m4a')">A. 🕌 Masjid</button>
            <button onclick="checkAnswer(this, 'B')" 
                    onmouseover="playSound('audio/rumah.m4a')">B. 🏠 Rumah</button>
            <button onclick="checkAnswer(this, 'C')" 
                    onmouseover="playSound('audio/taman.m4a')">C. 🎢 Taman</button>
            <button onclick="checkAnswer(this, 'D')" 
                    onmouseover="playSound('audio/hutan.m4a')">D. 🌲 Hutan</button>
            <button onclick="checkAnswer(this, 'E')" 
                    onmouseover="playSound('audio/tandas.m4a')">E. 🚻 Tandas</button>
        </div>
        
        <p id="feedback" style="font-size: 18px; font-weight: bold; margin-top: 20px;"></p>
    </main>
    <script>
        // Ambil skor semasa dari sessionStorage, atau tetapkan ke 0 jika belum ada
        let score = parseInt(sessionStorage.getItem('score')) || 0;

        // Paparkan skor semasa pada elemen #score
        const scoreDisplay = document.getElementById('score');
        scoreDisplay.textContent = score;

        // Fungsi untuk mainkan bunyi
        function playSound(file) {
            const audio = new Audio(file);
            audio.play();
        }

        // Fungsi untuk periksa jawapan
        function checkAnswer(button, answer) {
            const correctAnswer = 'A';
            const feedback = document.getElementById('feedback');

            if (answer === correctAnswer) {
                feedback.textContent = 'Betul! masjid ialah rumah untuk solat.';
                feedback.style.color = 'green';
                button.style.backgroundColor = 'green';

                // Tambah skor jika jawapan betul
                score += 10; // Tambah 10 mata untuk jawapan betul
                sessionStorage.setItem('score', score); // Simpan skor baru ke sessionStorage

                // Alihkan ke level5.php selepas 1 saat (untuk memberi masa melihat maklum balas)
                setTimeout(() => {
                    window.location.href = 'level6.php';
                }, 1000);
            } else {
                feedback.textContent = 'Salah. Cuba lagi.';
                feedback.style.color = 'red';
                button.style.backgroundColor = 'red';
            }

            // Kemas kini paparan skor
            scoreDisplay.textContent = score;
        }
    </script>
</body>
</html>
