<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 3 - Kuiz Pilihan Jawapan</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        /* Gaya untuk gambar */
        .quiz-image {
            display: block;
            margin: 10px auto;
            width: 200px;
            height: auto;
            border-radius: 10px;
        }

        /* Gaya untuk pilihan jawapan */
        .options button {
            margin: 5px 0;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            background-color: #3498db;
            color: #fff;
            border: none;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .options button:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
    <header>
        <!-- Skor di atas kiri -->
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <!-- Butang Tetapan di atas kanan -->
        <button class="settings-button" onclick="goToSettings()">Tetapan ⚙️</button>
    </header>

    <main>
        <h1>Level 3: Kuiz Pilihan Jawapan - Kisah Nabi</h1>
        <p style="font-size: 16px;">Jawab soalan dengan memilih pilihan jawapan yang betul. Pilih jawapan dengan bijak ya!</p>
        
        <div class="quiz-container">
            <div id="quiz-question">
                <p style="font-size: 18px;">Siapakah nabi terakhir dalam Islam?</p>
                <img src="gambar/nabi.jpg" alt="Gambar Nabi" class="quiz-image">
                <div class="options"><br><br>
                    <button onclick="checkAnswer('Nabi Muhammad')">A.Nabi Muhammad</button>
                    <button onclick="checkAnswer('Nabi Isa')">B.Nabi Isa</button>
                    <button onclick="checkAnswer('Nabi Musa')">C.Nabi Musa</button>
                    <button onclick="checkAnswer('Nabi Ibrahim')">D.    Nabi Ibrahim</button>
                </div>
            </div>
        </div>

        <!-- Pop-up mesej untuk hasil jawapan -->
        <div class="popup-message" id="popupMessage"></div>
    </main>

    <script>
        const scoreElement = document.getElementById('score');
        let score = parseInt(sessionStorage.getItem('score')) || 0;

        // Paparkan skor dari sesi penyimpanan
        scoreElement.textContent = score;

        function goToSettings() {
            window.location.href = 'settings.php';
        }

        function checkAnswer(answer) {
            if (answer === 'Nabi Muhammad') {
                showPopupMessage('Tahniah! Jawapan anda betul!', true);
                score += 10;
            } else {
                showPopupMessage('Jawapan salah. Cuba lagi!', false);
            }

            scoreElement.textContent = score;
            sessionStorage.setItem('score', score);

            setTimeout(() => {
                // Ubah kepada soalan baru atau tamatkan kuiz
                window.location.href = 'level4.php';
            }, 2000);
        }

        function showPopupMessage(message, isSuccess) {
            const popup = document.getElementById('popupMessage');
            popup.textContent = message;
            popup.style.backgroundColor = isSuccess ? '#2ECC71' : '#E74C3C';
            popup.style.color = '#fff';
            popup.style.display = 'block';

            setTimeout(() => {
                popup.style.display = 'none';
            }, 2000);
        }
    </script>
</body>
</html>
