<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 1 - Maze ke Masjid</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <!-- Skor di atas kiri -->
        <div class="score-container">
            Skor: <span id="score">0</span>/100
        </div>
        <!-- Butang Tetapan di atas kanan -->
        <button class="settings-button" onclick="goToSettings()">Tetapan ⚙️</button>
    </header>

    <main>
        <h1>Level 1: Laluan Maze ke Masjid</h1>
        <p>Bantu watak sampai ke Masjid tanpa terkena halangan!</p>
        <div class="maze-container">
            <div class="maze">
                <!-- Laluan Maze -->
                <div class="path start" data-step="1">1🏃‍♂️</div>
                <div class="wall"></div>
                <div class="path" data-step="2">2</div>
                <div class="wall"></div>
                <div class="path" data-step="3">3</div>
                <div class="wall"></div>
                <div class="path" data-step="4">4</div>
                <div class="wall"></div>
                <div class="path" data-step="5">5</div>
                <div class="wall"></div>
                <div class="path" data-step="6">6</div>
                <div class="path" data-step="7">7</div>
                <div class="path" data-step="8">8</div>
                <div class="path" data-step="9">9</div>
                <div class="wall"></div>
                <div class="path" data-step="10">10</div>
                <div class="wall"></div>
                <div class="path" data-step="11">11</div>
                <div class="wall"></div>
                <div class="path" data-step="12">12</div>
                <div class="path" data-step="13">13</div>
                <div class="path" data-step="14">14</div>
                <div class="wall"></div>
                <div class="path" data-step="15">15</div>
                <div class="path masjid" data-step="16">🕌</div>
            </div>
        </div>

        <!-- Container untuk mesej kejayaan -->
        <div id="successMessage" style="display:none;">
            <p>TANIAH ANDA SAMPAI KE MASJID!</p>
        </div>
    </main>

    <script>
        const paths = document.querySelectorAll('.path');
        const start = document.querySelector('.start');
        const masjid = document.querySelector('.masjid');
        const scoreElement = document.getElementById('score');
        const successMessage = document.getElementById('successMessage');

        let currentStep = 1; // Start at step 1
        let score = 0;

        paths.forEach(path => {
            path.addEventListener('click', () => {
                const step = parseInt(path.dataset.step);

                // Check if clicked path is the next correct step
                if (step === currentStep + 1) {
                    // Move character
                    const currentPath = document.querySelector(`[data-step="${currentStep}"]`);
                    currentPath.innerHTML = currentStep; // Reset the current path to its number
                    path.innerHTML = "🏃‍♂️"; // Add character to new path

                    // Update current step
                    currentStep = step;

                    // Check if reached masjid
                    if (path === masjid) {
                        // Add score and store it
                        score += 10;
                        scoreElement.textContent = score;
                        sessionStorage.setItem('score', score);

                        // Show success message
                        successMessage.style.display = "block";

                        // Redirect to next question after 3 seconds
                        setTimeout(() => {
                            window.location.href = 'level2.php'; // Gantikan dengan halaman soalan seterusnya
                        }, 3000); // 3 seconds delay
                    }
                } else {
                    // Highlight incorrect path
                    path.style.backgroundColor = "red";
                    setTimeout(() => {
                        path.style.backgroundColor = ""; // Reset color
                    }, 500);
                }
            });
        });

        function goToSettings() {
            window.location.href = 'settings.php';
        }
    </script>
</body>
</html>
