<?php
session_start();

// Memastikan skor dimulakan jika tidak ada
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0; // Set initial score to 0
}

$totalScore = 100; // Maksimum skor (contoh: 100)
$score = $_SESSION['score']; // Mendapatkan skor terkini dari sesi PHP
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Benda Hidup dan Bukan Hidup</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Score Display -->
    <div id="score-display">Skor: <?= $score ?>/<?= $totalScore ?></div>
    <button id="settings-button" onclick="window.location.href='setting.php'">⚙️ Settings</button>
        

    <!-- Game Screen -->
    <div id="game">
        <h2 id="level-title">Level 1</h2>
        <div class="question" id="question">Adakah benda ini Hidup atau Bukan Hidup?</div>
        <img id="question-image" src="image/tree.jpeg" alt="Science Question">
        <div class="options">
            <div class="option" onclick="checkAnswer('Hidup')">Hidup</div>
            <div class="option" onclick="checkAnswer('Bukan Hidup')">Bukan Hidup</div>
        </div>
        <p id="result" class="result"></p>
    </div>

    <script>
        const scoreDisplay = document.getElementById('score-display');
        const resultElement = document.getElementById('result');
        const levelTitle = document.getElementById('level-title');
        const questionImage = document.getElementById('question-image');
        let score = <?= $score ?>; // Mendapatkan skor terkini dari PHP
        let currentLevel = 1;

        // Array soalan dan jawapan yang betul
        const questions = [
            { image: 'image/tree.jpeg', correctAnswer: 'Hidup' },
            { image: 'image/rock.jpeg', correctAnswer: 'Bukan Hidup' },
            { image: 'image/flower.jpeg', correctAnswer: 'Hidup' },
            { image: 'image/dog.jpeg', correctAnswer: 'Hidup' },
            { image: 'image/bird.jpeg', correctAnswer: 'Hidup' },
            { image: 'image/phone.jpeg', correctAnswer: 'Bukan Hidup' },
            { image: 'image/house.jpeg', correctAnswer: 'Bukan Hidup' },
            { image: 'image/cat.jpeg', correctAnswer: 'Hidup' },
            { image: 'image/car.jpeg', correctAnswer: 'Bukan Hidup' },
            { image: 'image/bicycle.jpeg', correctAnswer: 'Bukan Hidup' }
        ];

        // Fungsi untuk mengemas kini paparan skor
        function updateScoreDisplay() {
            scoreDisplay.textContent = `Skor: ${score}/100`;
        }

        // Fungsi untuk memeriksa jawapan
        function checkAnswer(selectedOption) {
            const correctAnswer = questions[currentLevel - 1].correctAnswer; // Mendapatkan jawapan yang betul untuk level semasa
            if (selectedOption === correctAnswer) {
                score += 10; // Menambah 10 mata untuk jawapan yang betul
                resultElement.textContent = "Betul! Tahniah!";
                resultElement.style.color = "green";
                resultElement.classList.add('success');
            } else {
                resultElement.textContent = "Salah! Cuba lagi.";
                resultElement.style.color = "red";
                resultElement.classList.add('error');
            }

            // Hantar skor yang dikemas kini ke sesi PHP melalui AJAX
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'update_score.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.send('score=' + score);

            // Pergi ke level seterusnya selepas 2 saat
            setTimeout(() => {
                if (currentLevel < questions.length) {
                    currentLevel++;
                    loadLevel();
                } else {
                    resultElement.textContent = "Permainan selesai! Tahniah!";
                    // Alihkan ke score.php selepas permainan selesai
                    setTimeout(() => {
                        window.location.href = 'score.php'; // Alihkan ke halaman skor
                    }, 2000); // 2 saat sebelum alih
                }
            }, 2000);
        }

        // Fungsi untuk memuatkan level semasa
        function loadLevel() {
            levelTitle.textContent = `Level ${currentLevel}`;
            questionImage.src = questions[currentLevel - 1].image; // Kemaskini gambar untuk level semasa
            resultElement.textContent = ""; // Kosongkan hasil sebelum ini
            updateScoreDisplay(); // Kemas kini paparan skor
        }

        // Muatkan level pertama semasa halaman dimuat
        document.addEventListener('DOMContentLoaded', () => {
            loadLevel();
        });
    </script>
</body>
</html>
