<?php
session_start();
require '../../intro/config.php'; // Sambungan ke pangkalan data

// Semak jika pengguna telah log masuk dan skor wujud dalam sesi
if (!isset($_SESSION['username']) || !isset($_SESSION['score'])) {
    header('Location: game.php'); // Jika tiada sesi, kembali ke game
    exit();
}

$username = $_SESSION['username'];
$score = $_SESSION['score'];

// Pastikan username wujud dalam jadual pelajar
$query = "SELECT username FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) { // Jika username wujud dalam pelajar
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['submit_score'])) {
        // Simpan skor dalam jadual akidah
        $insertQuery = "INSERT INTO akidah (username, score) VALUES (?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("si", $username, $score);

        if ($stmt->execute()) {
            $_SESSION['score'] = 0; // Reset skor selepas disimpan
            header('Location: ../../murid5/indexTahun5.php'); // Redirect ke halaman utama
            exit();
        } else {
            echo "Ralat menyimpan skor: " . $stmt->error;
        }
    }
} else {
    echo "Ralat: Username tidak dijumpai dalam pangkalan data pelajar.";
}

$stmt->close();
$conn->close();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Kuiz</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #B6F49D;
            color: #333;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh; /* Full viewport height */
            text-align: center;
        }

        .container {
            max-width: 600px;
            width: 100%; /* Ensures it is responsive */
            padding: 20px;
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            text-align: center;
        }

        .score {
            font-size: 2rem;
            margin-bottom: 20px;
            color: #FFD700;
        }

        .message {
            font-size: 1.5rem;
            margin-bottom: 30px;
        }

        .home-button {
            padding: 10px 20px;
            background-color: #FFD700;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-size: 1.2rem;
            transition: background-color 0.3s;
        }

        .home-button:hover {
            background-color: #e6c400;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="score">
            Skor Anda: <?php echo $score; ?>
        </div>

        <div class="message">
            <?php
                if ($score >= 80) {
                    echo "Tahniah! Anda hebat!";
                } elseif ($score >= 50) {
                    echo "Bagus! Teruskan usaha!";
                } else {
                    echo "Jangan berputus asa! Cuba lagi!";
                }
            ?>
        </div>

        <br>

        <form action="score.php" method="get">
            <button type="submit" class="home-button" name="submit_score">Kembali Ke Halaman utama</button> 
        </form>
    </div>

</body>
</html>


