<?php
session_start();
// Reset score if the user visits this page directly
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

// Questions and answers
$questions = [
    ["question" => "Siapa Tuhan kita yang menciptakan kita semua?", "options" => ["Allah", "Nabi", "Malaikat"], "answer" => "Allah"],
    ["question" => "Kita mesti beriman kepada siapa?", "options" => ["Allah", "Bulan", "Pokok"], "answer" => "Allah"],
    ["question" => "Siapakah yang diciptakan Allah untuk melaksanakan tugas-tugas tertentu?", "options" => ["Malaikat", "Haiwan", "Manusia"], "answer" => "Malaikat"],
    ["question" => "Apa tugas malaikat Jibrail?", "options" => ["Membawa wahyu kepada Nabi", "Menanam pokok", "Makan makanan"], "answer" => "Membawa wahyu kepada Nabi"],
    ["question" => "Apakah nama kitab Allah yang diturunkan kepada Nabi Muhammad SAW?", "options" => ["Al-Quran", "Injil", "Taurat"], "answer" => "Al-Quran"],
    ["question" => "Kita mesti membaca kitab apa supaya mendapat pahala?", "options" => ["Al-Quran", "Komik", "Buku cerita"], "answer" => "Al-Quran"],
    ["question" => "Apa ucapan dua kalimah syahadah?", "options" => ["Aku bersaksi tiada Tuhan selain Allah dan Nabi Muhammad pesuruh Allah", "Saya mahu tidur", "Selamat pagi"], "answer" => "Aku bersaksi tiada Tuhan selain Allah dan Nabi Muhammad pesuruh Allah"],
    ["question" => "Mengucap dua kalimah syahadah adalah rukun Islam yang ke berapa?", "options" => ["Pertama", "Kedua", "Ketiga"], "answer" => "Pertama"],
    ["question" => "Berapa kali kita wajib solat setiap hari?", "options" => ["Lima kali", "Tiga kali", "Dua kali"], "answer" => "Lima kali"],
    ["question" => "Solat membantu kita menjadi apa?", "options" => ["Anak yang baik", "Letih", "Lapar"], "answer" => "Anak yang baik"],
];

// Save questions to session if not already done
if (!isset($_SESSION['questions'])) {
    $_SESSION['questions'] = $questions;
    $_SESSION['current_question'] = 0;
    $_SESSION['score'] = 0;
}

// Process answer
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['reset'])) {
        // Reset score and questions
        $_SESSION['current_question'] = 0;
        $_SESSION['score'] = 0;
        header('Location: game.php');
        exit();
    }

    $selected_option = $_POST['answer'];
    $current_question_index = $_SESSION['current_question'];
    $current_question = $_SESSION['questions'][$current_question_index];

    if ($selected_option === $current_question['answer']) {
        $_SESSION['score'] += 10;
    }

    $_SESSION['current_question']++;

    // If questions are done, go to the score page
    if ($_SESSION['current_question'] >= count($_SESSION['questions'])) {
        header('Location: score.php');
        exit();
    }
}

// Current question
$current_question_index = $_SESSION['current_question'];
if ($current_question_index < count($_SESSION['questions'])) {
    $current_question = $_SESSION['questions'][$current_question_index];
    $options = $current_question['options'];
    shuffle($options); // Shuffle options only if valid
} else {
    // If the current question exceeds the total questions, reset
    $_SESSION['current_question'] = 0;
    header('Location: score.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Kuiz Kanak-kanak</title>
    <style>
        /* Video background */
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            overflow: hidden;
            position: relative;
        }
        video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: -1; /* Keeps the video behind content */
        }

        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .question {
            font-size: 1.5rem;
            margin-bottom: 20px;
        }

        .options {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 15px; /* Adds spacing between buttons */
        }

        .options button {
            width: 80%; /* Set the width to 80% of the container */
            padding: 20px; /* Make the buttons larger */
            margin: 10px 0;
            background-color: #8FD694;
            border: none;
            border-radius: 15px; /* Slightly larger border radius for a smoother look */
            cursor: pointer;
            font-size: 1.2rem; /* Increase the font size for better readability */
            transition: background-color 0.3s, transform 0.2s; /* Smooth transition for hover and active states */
        }

        .options button:hover {
            background-color: #76c883;
        }

        .options button:active {
            transform: scale(0.98); /* Adds a subtle click effect */
        }

        .animation {
            font-size: 2.5rem; /* Increase the size for better visibility */
            color: #FFD700;
            margin-bottom: 30px;
            animation: bounce 1s infinite;
        }

        .score {
            position: absolute;
            top: 10px;
            left: 10px;
            font-size: 1.2rem;
            background: #fff;
            padding: 10px 20px;
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        .settings {
            position: absolute;
            top: 10px;
            right: 10px;
        }

        .settings button {
            background: #FFD700;
            border: none;
            padding: 10px 15px;
            border-radius: 10px;
            cursor: pointer;
            font-weight: bold;
        }

        @keyframes bounce {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }
    </style>
</head>
<body>
    <!-- Background Video -->
    <video autoplay muted loop>
        <source src="img/bg.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>

    <div class="score">Skor: <?php echo $_SESSION['score']; ?></div>
    <div class="settings">
        <form action="setting.php" method="get">
            <button type="submit" name="settings">Tetapan</button>
        </form>
    </div><br><br><br><br><br>
    <div class="container">
        <center><div class="animation">🌟 Kuiz PintarKids 🌟</div></center>
        <div class="question">
            <center><?php echo $current_question['question']; ?></center>
        </div>
        <form method="POST">
            <div class="options">
                <?php foreach ($options as $option): ?>
                    <button type="submit" name="answer" value="<?php echo $option; ?>">
                        <?php echo $option; ?>
                    </button>
                <?php endforeach; ?>
            </div>
        </form>
    </div>
</body>
</html>
